/***************************************************************************
*   Copyright (C) 2006-2012 by Thomas Schweitzer                          *
*   thomas-schweitzer(at)arcor.de                                         *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License version 2.0 as   *
*   published by the Free Software Foundation.                            *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program in the file LICENSE.GPL; if not, write to the *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/

#include "config.h"

#include "UiGuiSettingsDialog.h"
#include "UiGuiSettings.h"

#include <tqcheckbox.h>
#include <tqcombobox.h>
#include <tqpixmap.h>
#include <tqspinbox.h>
#include <tqtabwidget.h>

/*
    \class UiGuiSettingsDialog
    \ingroup grp_Settings
    \brief Displays a dialog window with settings for UniversalIndentGUI
*/

/*
    \brief The constructor calls the setup function for the ui created by uic.
*/
UiGuiSettingsDialog::UiGuiSettingsDialog(TQWidget *parent, UiGuiSettings *settings) :
		UiGuiSettingsDialogBase(parent)
{
	// Remember pointer to the UiGuiSettings object.
	m_settings = settings;

	// For icon setup
	const TQString ICONS_PATH(APP_ICONS_PATH);
	// Application icon
	setIcon(TQPixmap(ICONS_PATH + "preferences-system.png"));

	tabWidget->setTabIconSet(tabCommon, TQPixmap(ICONS_PATH + "applications-system.png"));
	tabWidget->setTabIconSet(tabEditor, TQPixmap(ICONS_PATH + "accessories-text-editor.png"));
	tabWidget->setTabIconSet(tabSyntaxHighlight, TQPixmap(ICONS_PATH + "syntax-highlight.png"));

	// Init the language selection combobox.
	initTranslationSelection();
}

/*
    \brief By calling this function the combobox for selecting the application language will
    be initialized.

    Also the translation itself will be reinitialized.
 */
void UiGuiSettingsDialog::initTranslationSelection()
{
	// For icon setup
	const TQString ICONS_PATH(APP_ICONS_PATH);

	// First empty the combo box.
	cmbBoxLanguageSelection->clear();

	// Now add an entry into the box for every language short.
	for (const TQString &languageShort : m_settings->getAvailableTranslations())
	{
		// Identify the language mnemonic and set the full name.
		if (languageShort == "en")
		{
			cmbBoxLanguageSelection->insertItem(TQPixmap(ICONS_PATH + "language-en.png"), tr("English"));
		}
		else if (languageShort == "fr")
		{
			cmbBoxLanguageSelection->insertItem(TQPixmap(ICONS_PATH + "language-fr.png"), tr("French"));
		}
		else if (languageShort == "de")
		{
			cmbBoxLanguageSelection->insertItem(TQPixmap(ICONS_PATH + "language-de.png"), tr("German"));
		}
		else if (languageShort == "zh_TW")
		{
			cmbBoxLanguageSelection->insertItem(TQPixmap(ICONS_PATH + "language-zh_TW.png"),
			        tr("Chinese (Taiwan)"));
		}
		else if (languageShort == "ja")
		{
			cmbBoxLanguageSelection->insertItem(TQPixmap(ICONS_PATH + "language-ja.png"), tr("Japanese"));
		}
		else if (languageShort == "ru")
		{
			cmbBoxLanguageSelection->insertItem(TQPixmap(ICONS_PATH + "language-ru.png"), tr("Russian"));
		}
		else if (languageShort == "uk")
		{
			cmbBoxLanguageSelection->insertItem(TQPixmap(ICONS_PATH + "language-uk.png"), tr("Ukrainian"));
		}
	}
}

/*
    \brief Displays the dialog by calling the dialogs exec function.

    Before it gets all the values needed from the UiGuiSettings object.
 */
void UiGuiSettingsDialog::showDialog()
{
	// Init all settings dialog objects with values from settings.
	cbLoadLastOpenedFileOnStartup->setChecked(
	        m_settings->getValueByName("LoadLastOpenedFileOnStartup").toBool());
	cbEnableIndenterParameterTooltips->setChecked(
	        m_settings->getValueByName("IndenterParameterTooltipsEnabled").toBool());
	cbWhiteSpaceIsVisible->setChecked(
	        m_settings->getValueByName("WhiteSpaceIsVisible").toBool());
	cbEnableSyntaxHL->setChecked(
	        m_settings->getValueByName("SyntaxHighlightingEnabled").toBool());
	sbRecentlyOpenedListSize->setValue(m_settings->getValueByName("RecentlyOpenedListSize").toInt());
	sbTabWidth->setValue(m_settings->getValueByName("TabWidth").toInt());

  // Execute the dialog.
	if (exec() == TQDialog::Accepted)
	{
		updateSettings();
	}
}

/*
    \brief This slot is called when the dialog box is closed by pressing the Ok button.

    Writes all settings to the UiGuiSettings object.
 */
void UiGuiSettingsDialog::updateSettings()
{
	m_settings->setValueByName("LoadLastOpenedFileOnStartup",
	        cbLoadLastOpenedFileOnStartup->isChecked());
	m_settings->setValueByName("IndenterParameterTooltipsEnabled",
	        cbEnableIndenterParameterTooltips->isChecked());
	m_settings->setValueByName("RecentlyOpenedListSize", sbRecentlyOpenedListSize->value());
	m_settings->setValueByName("WhiteSpaceIsVisible", cbWhiteSpaceIsVisible->isChecked());
	m_settings->setValueByName("TabWidth", sbTabWidth->value());
	m_settings->setValueByName("SyntaxHighlightingEnabled", cbEnableSyntaxHL->isChecked());
}

//--- /*
//---     \brief Catches language change events and retranslates all needed widgets.
//---  */
//--- void UiGuiSettingsDialog::changeEvent(TQEvent *event)
//--- {
//--- 	if (event->type() == TQEvent::LanguageChange)
//--- 	{
//--- 		retranslateUi(this);
//--- 		// If this is not explicit set here, TQt < 4.3.0 does not translate the buttons.
//--- 		buttonBox->setStandardButtons(
//--- 			TQDialogButtonBox::Cancel | TQDialogButtonBox::NoButton | TQDialogButtonBox::Ok);
//--- 
//--- 		//TODO: This has to be removed when the properties for the highlighters can be set.
//--- 		groupBoxSyntaxHighlighterProperties->setToolTip(
//--- 			"(Will be implemented soon)" +
//--- 			groupBoxSyntaxHighlighterProperties->toolTip());
//--- 
//--- 		TQStringList languageShortList = m_settings->getAvailableTranslations();
//--- 
//--- 		// Now retranslate every entry in the language selection box.
//--- 		for (int i = 0; i < languageShortList.size(); i++)
//--- 		{
//--- 			TQString languageShort = languageShortList.at(i);
//--- 
//--- 			// Identify the language mnemonic and set the full name.
//--- 			if (languageShort == "en")
//--- 			{
//--- 				cmbBoxLanguageSelection->setItemText(i, tr("English"));
//--- 			}
//--- 			else if (languageShort == "fr")
//--- 			{
//--- 				cmbBoxLanguageSelection->setItemText(i, tr("French"));
//--- 			}
//--- 			else if (languageShort == "de")
//--- 			{
//--- 				cmbBoxLanguageSelection->setItemText(i, tr("German"));
//--- 			}
//--- 			else if (languageShort == "zh_TW")
//--- 			{
//--- 				cmbBoxLanguageSelection->setItemText(i, tr("Chinese (Taiwan)"));
//--- 			}
//--- 			else if (languageShort == "ja")
//--- 			{
//--- 				cmbBoxLanguageSelection->setItemText(i, tr("Japanese"));
//--- 			}
//--- 			else if (languageShort == "ru")
//--- 			{
//--- 				cmbBoxLanguageSelection->setItemText(i, tr("Russian"));
//--- 			}
//--- 			else if (languageShort == "uk")
//--- 			{
//--- 				cmbBoxLanguageSelection->setItemText(i, tr("Ukrainian"));
//--- 			}
//--- 			else
//--- 			{
//--- 				cmbBoxLanguageSelection->setItemText(i,
//--- 				        tr("Unknown language mnemonic ") + languageShort);
//--- 			}
//--- 		}
//--- 	}
//--- 	else
//--- 	{
//--- 		TQWidget::changeEvent(event);
//--- 	}
//--- }

#include "UiGuiSettingsDialog.moc"
