/*******************************************************************************
  XDG desktop portal implementation for TDE
  Copyright © 2024 Mavridis Philippe <mavridisf@gmail.com>

  This program or library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 2.1 of the License,
  or (at your option) any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
  FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
  details.

  You should have received a copy of the GNU Lesser General Public License
  along with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

  Improvements and feedback are welcome!
*******************************************************************************/

#ifndef __REQUEST_H
#define __REQUEST_H

// TQt
#include <tqobject.h>
#include <tqvariant.h>
#include <tqdbusconnection.h>
#include <tqdbusmessage.h>
#include <tqdbusobject.h>
#include <tqdbusobjectpath.h>

class Request : public TQObject, TQT_DBusObjectBase
{
    TQ_OBJECT

    public:
        Request(TQT_DBusConnection connection, const TQT_DBusObjectPath &handle,
                TQObject *parent, const TQVariant data = TQVariant());
        virtual ~Request();

    protected:
        virtual bool handleMethodCall(const TQT_DBusMessage& message);

    signals:
        void closeRequested(); // when we don't care about data
        void closeRequested(const TQVariant &data);

    private:
        TQT_DBusConnection m_connection;
        const TQT_DBusObjectPath &m_handle;
        const TQVariant m_data;
        bool m_registered;
};

#endif // __REQUEST_H

// kate: replace-tabs true; tab-width 4; indent-width 4;