/*
 *
 * This file is part of the KDE project, module tdefile.
 * Copyright (C) 2006 Luke Sandell <lasandell@gmail.com>
 *           (C) 2002 Carsten Pfeiffer <pfeiffer@kde.org>
 *           (C) 2000 Geert Jansen <jansen@kde.org>
 *           (C) 2000 Kurt Granroth <granroth@kde.org>
 *           (C) 1997 Christoph Neerfeld <chris@kde.org>
 *
 * This is free software; it comes under the GNU Library General
 * Public License, version 2. See the file "COPYING.LIB" for the
 * exact licensing terms.
 */

#ifndef _KICONCANVAS_H_
#define _KICONCANVAS_H_

#include <tqstring.h>
#include <tqstringlist.h>
#include <kiconview.h>

class TQTimer;
class TDEIconLoader;
class TQDragObject;
class TQIconLoader;

/**
 * Icon canvas for TDEIconDialog.
 */
class TDEIO_EXPORT TDEIconCanvas: public TDEIconView
/* NOTE: Why export this? */
{
    TQ_OBJECT
  

public:
    TDEIconCanvas(TQWidget *parent=0L, const char *name=0L);
    ~TDEIconCanvas();

    /**
     * Load icons into the canvas.
     */
    void loadFiles(const TQStringList& files);

    /**
     * Returns the current icon.
     */
    TQString getCurrent() const;

    void setIconLoader(TDEIconLoader *loader);

    void setGroupOrSize(int groupOrSize);

    void setStrictIconSize(bool strictIconSize);

public slots:
    void stopLoading();

signals:
    /**
     * Emitted when the current icon has changed.
     */
    void nameChanged(TQString);
    /* KDE 4: Make it const TQString */

    void startLoading(int);
    void progress(int);
    void finished();

private slots:
    void slotLoadFiles();
    void slotCurrentChanged(TQIconViewItem *item);

private:
    TQStringList mFiles;
    TQTimer *mpTimer;
    TDEIconLoader *mpLoader;

protected:
    virtual void virtual_hook( int id, void* data );
    virtual TQDragObject *dragObject();
    void loadIcon(const TQString &path);

private:
    class TDEIconCanvasPrivate;
    TDEIconCanvasPrivate *d;
};

#endif
