/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2008-04-07
 * Description : Raw camera list dialog
 *
 * Copyright (C) 2008 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

// TQt includes.

#include <tqlayout.h>
#include <tqstringlist.h>
#include <tqstring.h>
#include <tqlabel.h>
#include <tqlistview.h>
#include <tqheader.h>

// KDE includes.

#include <tdelocale.h>
#include <kiconloader.h>
#include <tdeapplication.h>
#include <tdeaboutdata.h>

// LibKDcraw includes.

#include <libkdcraw/version.h>
#include <libkdcraw/kdcraw.h>

#if KDCRAW_VERSION < 0x000106
#include <libkdcraw/dcrawbinary.h>
#endif

// Local includes.

#include "searchtextbar.h"
#include "rawcameradlg.h"
#include "rawcameradlg.moc"

namespace Digikam
{

class RawCameraDlgPriv
{
public:

    RawCameraDlgPriv()
    {
        listView  = 0;
        searchBar = 0;
    }

    TQListView     *listView;

    SearchTextBar *searchBar;
};

RawCameraDlg::RawCameraDlg(TQWidget *parent)
            : KDialogBase(parent, 0, true, TQString(), Help|Ok, Ok, true)
{
    setHelp("digitalstillcamera.anchor", "digikam");
    setCaption(i18n("List of supported RAW cameras"));

    d = new RawCameraDlgPriv;

    TQWidget *page     = makeMainWidget();
    TQGridLayout* grid = new TQGridLayout(page, 2, 2, 0, spacingHint());

#if KDCRAW_VERSION < 0x000106
    TQStringList list      = KDcrawIface::DcrawBinary::instance()->supportedCamera();
    TQString     dcrawVer  = KDcrawIface::DcrawBinary::instance()->internalVersion();
#else
    TQStringList list      = KDcrawIface::KDcraw::supportedCamera();
    TQString     librawVer = KDcrawIface::KDcraw::librawVersion();
#endif
    TQString     KDcrawVer = KDcrawIface::KDcraw::version();

    // --------------------------------------------------------

    TQLabel *logo            = new TQLabel(page);
    TDEIconLoader* iconLoader = tdeApp->iconLoader();

    if (tdeApp->aboutData()->appName() == TQString("digikam"))
        logo->setPixmap(iconLoader->loadIcon("digikam", TDEIcon::NoGroup, 96, TDEIcon::DefaultState, 0, true));
    else
        logo->setPixmap(iconLoader->loadIcon("showfoto", TDEIcon::NoGroup, 96, TDEIcon::DefaultState, 0, true));

    // --------------------------------------------------------

    TQLabel *header = new TQLabel(page);
#if KDCRAW_VERSION < 0x000106
    header->setText(i18n("<p>Using KDcraw library version %1"
                         "<p>Using Dcraw program version %2"
                         "<p>%3 models in the list")
                         .arg(KDcrawVer).arg(dcrawVer).arg(list.count()));
#else
    header->setText(i18n("<p>Using KDcraw library version %1"
                         "<p>Using LibRaw version %2"
                         "<p>%3 models in the list")
                         .arg(KDcrawVer).arg(librawVer).arg(list.count()));
#endif

    // --------------------------------------------------------

    d->searchBar = new SearchTextBar(page, "RawCameraDlgSearchBar");
    d->listView  = new TQListView(page);
    d->listView->addColumn("Camera Model");       // Header is hiden. No i18n here.
    d->listView->setSorting(1);
    d->listView->header()->hide();
    d->listView->setResizeMode(TQListView::LastColumn);

    for (TQStringList::Iterator it = list.begin() ; it != list.end() ; ++it)
        new TQListViewItem(d->listView, *it);

    // --------------------------------------------------------


    grid->addMultiCellWidget(logo,         0, 0, 0, 0);
    grid->addMultiCellWidget(header,       0, 0, 1, 2);
    grid->addMultiCellWidget(d->listView,  1, 1, 0, 2);
    grid->addMultiCellWidget(d->searchBar, 2, 2, 0, 2);
    grid->setColStretch(1, 10);
    grid->setRowStretch(1, 10);

    // --------------------------------------------------------

    connect(d->searchBar, TQ_SIGNAL(signalTextChanged(const TQString&)),
            this, TQ_SLOT(slotSearchTextChanged(const TQString&)));

    resize(500, 500);
}

RawCameraDlg::~RawCameraDlg()
{
    delete d;
}

void RawCameraDlg::slotSearchTextChanged(const TQString& filter)
{
    bool query     = false;
    TQString search = filter.lower();

    TQListViewItemIterator it(d->listView);

    for ( ; it.current(); ++it )
    {
        TQListViewItem *item  = it.current();

        if (item->text(0).lower().contains(search))
        {
            query = true;
            item->setVisible(true);
        }
        else
        {
            item->setVisible(false);
        }
    }

    d->searchBar->slotSearchResult(query);
}

}  // NameSpace Digikam
