/***************************************************************************
 *   Copyright (C) 2004-2007 by Georgy Yunaev, gyunaev@ulduzsoft.com       *
 *   Please do not use email address above for bug reports; see            *
 *   the README file                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include "kchmkeyeventfilter.h"

KCHMKeyEventFilter	gKeyEventFilter;

KCHMKeyEventFilter::KCHMKeyEventFilter()
 : TQObject()
{
	m_shiftPressed = false;
	m_ctrlPressed = false;
}

bool KCHMKeyEventFilter::eventFilter( TQObject *, TQEvent *e )
{
	// Handle KeyPress and KeyRelease events
	if ( e->type() == TQEvent::KeyPress || e->type() == TQEvent::KeyRelease )
	{
		bool * ptr = 0;
		TQKeyEvent *k = (TQKeyEvent *) e;
		
		// We're interested only in Shift and Control
		if ( k->key() == TQt::Key_Shift )
			ptr = &m_shiftPressed;
		else if ( k->key() == TQt::Key_Control )
			ptr = &m_ctrlPressed;
		
		// Set it
		if ( ptr )
			*ptr = e->type() == TQEvent::KeyPress ? true : false;
	}

	return false;	// Standard event processing
}
