/*
 * This file is part of the KFTPGrabber project
 *
 * Copyright (C) 2003-2005 by the KFTPGrabber developers
 * Copyright (C) 2003-2005 Jernej Kos <kostko@jweb-network.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * is provided AS IS, WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, and
 * NON-INFRINGEMENT.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 *
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 */

#include <tqpointarray.h>
#include <tqpushbutton.h>
#include <tqtooltip.h>
#include <tqlayout.h>
#include <tqlabel.h>

#include <tdeapplication.h>
#include <kdialog.h>
#include <tdelocale.h>
#include <tdestandarddirs.h>
#include <kactivelabel.h>
#include <tdeglobalsettings.h>

#include "widgets/balloon.h"
#include "misc.h"

using namespace KFTPGrabberBase;

namespace KFTPWidgets {

Balloon::Balloon(const TQString &text, const TQString &pix)
  : TQWidget(0L, "KFTPBalloon", WStyle_StaysOnTop | WStyle_Customize | WStyle_NoBorder | WStyle_Tool | WX11BypassWM)
{
  setCaption("");

  TQVBoxLayout *BalloonLayout = new TQVBoxLayout(this, 22, KDialog::spacingHint(), "BalloonLayout");

  // BEGIN Layout1
  TQHBoxLayout *Layout1 = new TQHBoxLayout(BalloonLayout, KDialog::spacingHint(), "Layout1");
  KActiveLabel *caption = new KActiveLabel(text, this, "caption");
  caption->setPalette(TQToolTip::palette());
  caption->setSizePolicy(TQSizePolicy::Minimum, TQSizePolicy::Minimum);

  if (!pix.isEmpty()) {
    TQLabel *image = new TQLabel(this, "mImage");
    image->setScaledContents(false);
    image->setPixmap(loadSmallPixmap(pix));

    Layout1->addWidget(image);
  }

  Layout1->addWidget(caption);
  // END Layout1

  setPalette(TQToolTip::palette());
  setAutoMask(true);

  connect(caption, TQ_SIGNAL(clicked(int, int)), this, TQ_SIGNAL(signalBalloonClicked()));
  connect(caption, TQ_SIGNAL(linkClicked(const TQString &)), this, TQ_SIGNAL(signalIgnoreButtonClicked()));
  connect(caption, TQ_SIGNAL(linkClicked(const TQString &)), this, TQ_SLOT(deleteLater()));
}

void Balloon::mousePressEvent(TQMouseEvent *e)
{
  emit signalBalloonClicked();
  e->accept();
}

void Balloon::setAnchor(const TQPoint &anchor)
{
  m_anchor = anchor;
  updateMask();
}

void Balloon::updateMask()
{
  TQRegion mask(10, 10, width() - 20, height() - 20);

  TQPoint corners[8] = {
    TQPoint(width() - 50, 10),
    TQPoint(10, 10),
    TQPoint(10, height() - 50),
    TQPoint(width() - 50, height() - 50),
    TQPoint(width() - 10, 10),
    TQPoint(10, 10),
    TQPoint(10, height() - 10),
    TQPoint(width() - 10, height() - 10)
  };

  for (int i = 0; i < 4; ++i) {
    TQPointArray corner;
    corner.makeArc(corners[i].x(), corners[i].y(), 40, 40, i * 16 * 90, 16 * 90);
    corner.resize(corner.size() + 1);
    corner.setPoint(corner.size() - 1, corners[i + 4]);
    mask -= corner;
  }

  // get screen-geometry for screen our anchor is on
  // (geometry can differ from screen to screen!)
  TQRect deskRect = TDEGlobalSettings::desktopGeometry(m_anchor);

  bool bottom = (m_anchor.y() + height()) > (deskRect.height() - 48);
  bool right = (m_anchor.x() + width()) > (deskRect.width() - 48);

  TQPointArray arrow(4);
  arrow.setPoint(0, TQPoint(right ? width() : 0, bottom ? height() : 0));
  arrow.setPoint(1, TQPoint(right ? width() - 10 : 10, bottom ? height() - 30 : 30));
  arrow.setPoint(2, TQPoint(right ? width() - 30 : 30, bottom ? height() - 10 : 10));
  arrow.setPoint(3, arrow[0]);
  mask += arrow;
  setMask(mask);

  move(right ? m_anchor.x() - width() : m_anchor.x(), bottom ? m_anchor.y() - height() : m_anchor.y());
}

}

#include "balloon.moc"

