/***************************************************************************
 * copyright            : (C) 2006 Seb Ruiz <me@sebruiz.net>               *
 **************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <glib-object.h> //g_type_init

#include "ipodexportdialog.h"
#include "plugin_ipodexport.h"

#include <libkipi/imagecollection.h>


#include <tdeaction.h>
#include <tdeapplication.h>
#include <tdeconfig.h>
#include <kdebug.h>
#include <kgenericfactory.h>
#include <klibloader.h>
#include <tdelocale.h>


#define debug() kdDebug( 51000 )

typedef KGenericFactory<Plugin_iPodExport> Factory;

K_EXPORT_COMPONENT_FACTORY( kipiplugin_ipodexport, Factory("kipiplugin_ipodexport"));

Plugin_iPodExport::Plugin_iPodExport( TQObject *parent, const char*, const TQStringList& )
    : KIPI::Plugin( Factory::instance(), parent, "iPodExport")
{
    kdDebug( 51001 ) << "Plugin_iPodExport plugin loaded" << endl;

    g_type_init();
}

void Plugin_iPodExport::setup( TQWidget* widget )
{
    KIPI::Plugin::setup( widget );

    // this is our action shown in the menubar/toolbar of the mainwindow
    m_actionImageUpload = new TDEAction( i18n( "Export to iPod..." ), "multimedia-player-unmounted", 0, this,
                                      TQ_SLOT( slotImageUpload() ), actionCollection(), "connectipod");

    addAction( m_actionImageUpload );

    m_interface = dynamic_cast< KIPI::Interface* >( parent() );
}

KIPI::Category Plugin_iPodExport::category( TDEAction* action ) const
{
    if ( action == m_actionImageUpload )
        return KIPI::EXPORTPLUGIN;

    return KIPI::IMAGESPLUGIN; // no warning from compiler, please
}


void Plugin_iPodExport::slotImageUpload()
{
    IpodExport::UploadDialog *dlg = new IpodExport::UploadDialog( m_interface, i18n("iPod Export"),
                                                                  tdeApp->activeWindow() );
    dlg->setMinimumWidth( 460 );
    dlg->show();
}
