/* ============================================================
 *
 * This file is a part of kipi-plugins project
 * http://www.kipi-plugins.org
 *
 * Date        : 2005-07-07
 * Description : a kipi plugin to export images to Flickr web service
 *
 * Copyright (C) 2005-2008 by Vardhman Jain <vardhman at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef FLICKRITEM_H
#define FLICKRITEM_H

// TQt includes.

#include <tqstring.h>

namespace KIPIFlickrExportPlugin
{

class GPhoto
{

public:

    GPhoto()
    {
//      ref_num = -1;
    }

    bool     is_public;
    bool     is_private;
    bool     is_family;

    int      ref_num;
//  int      album_num;

    TQStrList tags;
    TQString  title;
    TQString  description;

//  TQString  caption;
//  TQString  thumbName;
//  TQString  albumURL;
};

// -------------------------------------------------------------

class FPhotoInfo
{

public:

    FPhotoInfo()
    {
        is_public = false;
        is_family = false;
        is_friend = false;
    }

    bool        is_public;
    bool        is_friend;
    bool        is_family;

    TQString     title;
    TQString     description;
    TQStringList tags;
};

// -------------------------------------------------------------

class GAlbum
{

public:

    GAlbum()
    {
        ref_num        = -1;
        parent_ref_num = -1;

        add            = false;
        write          = false;
        del_item       = false;
        del_alb        = false;
        create_sub     = false;
    }

    bool    add;
    bool    write;
    bool    del_item;
    bool    del_alb;
    bool    create_sub;

    int     ref_num;
    int     parent_ref_num;

    TQString name;
    TQString parentName;
    TQString title;
    TQString summary;
    TQString baseurl;
};

// -------------------------------------------------------------

class FPhotoSet
{

public:

    FPhotoSet()
    {
        id = "-1";
    }

    TQString id;
    TQString primary;    //="2483" 
    TQString secret;     //="abcdef"
    TQString server;
    TQString photos;
    TQString title;
    TQString description;
};

} // namespace KIPIFlickrExportPlugin

#endif /* FLICKRITEM_H */
