/* ============================================================
 * File   : plugin_wallpaper.cpp
 *
 * Authors: Gregory KOKANOSKY <gregory dot kokanosky at free.fr>
 *          Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * Date   : 01/2004
 *
 * Description : Set Wall paper plugin for KIPI
 *
 * Copyright 2004 by Gregory KOKANOSKY <gregory dot kokanosky at free.fr>
 * Copyright 2004 by Gilles CAULIER <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * ============================================================ */

// Include files for KDE

 #include <tdelocale.h>
 #include <tdeaction.h>
 #include <kgenericfactory.h>
 #include <klibloader.h>
 #include <tdeconfig.h>
 #include <kdebug.h>
 #include <tdeversion.h>
 #include <krun.h>
 #include <tdeapplication.h>
 #include <tdemessagebox.h>
 #include <ktextbrowser.h>
 #include <tdeversion.h>
 #include <tdefiledialog.h>
 #include <tdeio/netaccess.h>

// KIPI includes

 #include <libkipi/interface.h>
 #include <libkipi/imagecollection.h>

// Local includes

 #include "plugin_wallpaper.h"

typedef KGenericFactory<Plugin_WallPaper> Factory;

K_EXPORT_COMPONENT_FACTORY( kipiplugin_wallpaper,
                            Factory("kipiplugin_wallpaper"))

 /////////////////////////////////////////////////////////////////////////////////////////////////////

 Plugin_WallPaper::Plugin_WallPaper(TQObject *parent, const char*, const TQStringList&)
                       : KIPI::Plugin( Factory::instance(), parent, "WallPaper")
 {
     kdDebug( 51001 ) << "Plugin_WallPaper plugin loaded" << endl;
 }

void Plugin_WallPaper::setup( TQWidget* widget )
{
    KIPI::Plugin::setup( widget );

    m_action_Background = new TDEActionMenu(i18n("&Set as Background"),
                         actionCollection(),
                         "images2desktop");

    m_action_Background->insert(new TDEAction (i18n("Centered"),
                         0,
                         this,
                         TQ_SLOT(slotSetCenter()),
                         actionCollection(),
                         "images2desktop_center"));

    m_action_Background->insert(new TDEAction (i18n("Tiled"),
                         0,
                         this,
                         TQ_SLOT(slotSetTiled()),
                         actionCollection(),
                         "images2desktop_tiled"));

    m_action_Background->insert(new TDEAction (i18n("Centered Tiled"),
                         0,
                         this,
                         TQ_SLOT(slotSetCenterTiled()),
                         actionCollection(),
                         "images2desktop_center_tiled"));

    m_action_Background->insert(new TDEAction (i18n("Centered Max-Aspect"),
                         0,
                         this,
                         TQ_SLOT(slotSetCenteredMaxpect()),
                         actionCollection(),
                         "images2desktop_center_maxpect"));

    m_action_Background->insert(new TDEAction (i18n("Tiled Max-Aspect"),
                         0,
                         this,
                         TQ_SLOT(slotSetTiledMaxpect()),
                         actionCollection(),
                         "images2desktop_tiled_maxpect"));

    m_action_Background->insert(new TDEAction (i18n("Scaled"),
                         0,
                         this,
                         TQ_SLOT(slotSetScaled()),
                         actionCollection(),
                         "images2desktop_scaled"));

    m_action_Background->insert(new TDEAction (i18n("Centered Auto Fit"),
                         0,
                         this,
                         TQ_SLOT(slotSetCenteredAutoFit()),
                         actionCollection(),
                         "images2desktop_centered_auto_fit"));

    //The Scale & crop code was available from Beta1 on
    #if KDE_IS_VERSION(3,3,91)
    m_action_Background->insert(new TDEAction (i18n("Scale && Crop"),
			 0,
			 this,
			 TQ_SLOT(slotSetScaleAndCrop()),
			 actionCollection(),
			 "images2desktop_scale_and_crop"));

   #endif
    
    addAction( m_action_Background );

    KIPI::Interface* interface = dynamic_cast<KIPI::Interface*>( parent() );

    if ( !interface )
           {
           kdError( 51000 ) << "Kipi interface is null!" << endl;
           return;
           }

    KIPI::ImageCollection selection = interface->currentSelection();
    m_action_Background->setEnabled( selection.isValid() );

    connect( interface, TQ_SIGNAL(selectionChanged(bool)),
             m_action_Background, TQ_SLOT(setEnabled(bool)));
 }


/////////////////////////////////////////////////////////////////////////////////////////////////////

void Plugin_WallPaper::slotSetCenter()
{
   return setWallpaper(CENTER);
}


/////////////////////////////////////////////////////////////////////////////////////////////////////

void Plugin_WallPaper::slotSetTiled()
{
   return setWallpaper(TILED);
}


/////////////////////////////////////////////////////////////////////////////////////////////////////

void Plugin_WallPaper::slotSetCenterTiled()
{
   return  setWallpaper(CENTER_TILED);
}


/////////////////////////////////////////////////////////////////////////////////////////////////////

void Plugin_WallPaper::slotSetCenteredMaxpect()
{
   return setWallpaper(CENTER_MAXPECT);
}


/////////////////////////////////////////////////////////////////////////////////////////////////////

void Plugin_WallPaper::slotSetTiledMaxpect()
{
   return setWallpaper(TILED_MAXPECT);
}


/////////////////////////////////////////////////////////////////////////////////////////////////////

void Plugin_WallPaper::slotSetScaled()
{
   return setWallpaper(SCALED);
}


/////////////////////////////////////////////////////////////////////////////////////////////////////

void Plugin_WallPaper::slotSetCenteredAutoFit()
{
   return setWallpaper(CENTERED_AUTOFIT);
}

/////////////////////////////////////////////////////////////////////////////////////////////////////

void Plugin_WallPaper::slotSetScaleAndCrop()
{
   return setWallpaper(SCALE_AND_CROP);
}

/////////////////////////////////////////////////////////////////////////////////////////////////////

void Plugin_WallPaper::setWallpaper(int layout)
{
   if (layout>SCALE_AND_CROP || layout < CENTER)
      return;

   KIPI::Interface* interface = dynamic_cast<KIPI::Interface*>( parent() );

   if ( !interface )
           {
           kdError( 51000 ) << "Kipi interface is null!" << endl;
           return;
           }

   KIPI::ImageCollection images = interface->currentSelection();

   if (!images.isValid() ) return;

   KURL url=images.images()[0];
   TQString path;
   if (url.isLocalFile())
      {
      path=url.path();
      }
   else
      {
      // PENDING We need a way to get a parent widget
      // Sun, 06 Jun 2004 - Aur�ien

      KMessageBox::information( tdeApp->activeWindow(), i18n(
         "<qt><p>You selected a remote image. It needs to be saved to your local disk to be used as a wallpaper."
         "</p><p>You will now be asked where to save the image.</p></qt>"));
      path = KFileDialog::getSaveFileName(url.fileName(), TQString(), tdeApp->activeWindow());

      if (path.isNull()) return;
#if TDE_VERSION > 0x30200
      TDEIO::NetAccess::download(url, path, 0L);
#else
      TDEIO::NetAccess::download(url, path);
#endif
      }

   TQString cmd = TQString("dcop kdesktop KBackgroundIface setWallpaper '%1' %2")
                         .arg(path).arg(layout);

   KRun::runCommand(cmd);
}


/////////////////////////////////////////////////////////////////////////////////////////////////////

KIPI::Category  Plugin_WallPaper::category( TDEAction* action ) const
{
    if ( action == m_action_Background )
       return KIPI::IMAGESPLUGIN;

    kdWarning( 51000 ) << "Unrecognized action for plugin category identification" << endl;
    return KIPI::IMAGESPLUGIN; // no warning from compiler, please
}

#include "plugin_wallpaper.moc"
