KKBSwitch - a keyboard layout indicator for TDE.


KKBSwitch displays an icon in the system tray that indicates which
layout is currently active and enables you to switch layouts by clicking
the icon or by selecting from the menu.


It is useful when you have configured the XKeyboard extension of your
Xorg Server to have more than one keyboard group, for example US/ASCII
and Russian. It displays an icon in the system tray that indicates which
layout is currently active. Note that KKBSwitch does not help you
configure XKeyboard, it merely serves as the indicator of the current
group.


Features include:
-----------------

- displays an icon in the system tray indicating the active keyboard
  group.
- Configurable icons for the keyboard layouts (chosen from country flag
  pixmaps that ship with TDE).
- The "toggle mode" to toggle between the two most recently-used
  keyboard layouts.
- Choose to use a global layout, a per-application layout or
  a per-window layout.
- Configurable keyboard shortcuts.


NB: You still have to configure XKeyboard with the usual xorg options
(XkbModel, XkbLayout, XkbVariant and XkbOptions).


Using KKBSwitch
-----------------

The most basic usage is simply to let it sit in the system tray and show
you which keyboard group is currently active. You can also click the
KKBSwitch system tray icon to switch keyboard layouts.
When right-clicked, the system tray icon displays a menu with the
following entries:

- one or more entries corresponding to the configured keyboard groups
  (XKeyboard can have up to 4 groups configured). The currently active
  group will be checked.
  Selecting a menu entry corresponding to a group will make that group
  active.
- "Configure Keyboard Switch..." entry lets you configure KKBSwitch
- "About Keyboard Switch" displays a standard "About" dialog
- "Quit" quits KKBSwitch.


Configuring KKBSwitch
-----------------------

In the KKBSwitch configuration dialog you can do the following:
- set the icons corresponding to the available keyboard groups. Note
that KKBSwitch will try hard to guess the correct icon based on the name
of the keyboard group (the names are configured in XKeyboard).
For example, it will display the US flag for US/ASCII group, German flag
for German group, Russian flag for Russian group, etc. If it cannot
guess an icon, it will display the "default" icon, which simply shows
the group's number. Use the configuration dialog to customize the icons:
- select a group in the "Available keyboard groups" listbox, and click
"Change icon..." button. You will be able to select from the list of
country flag pixmaps that is shipped with TDE.
- turn the "Toggle mode" on and off. "Toggle mode" is a convient feature
of KKBSwitch, which is useful if you have more than 2 groups.
When "Toggle mode" is on, pressing the XKeyboard's group switch key or
clicking KKBSwitch's tray icon will toggle between the two most recently
used groups. To activate the third or the fourth (if available) group
you'll need to right-click KKBSwitch's tray icon and select the desired
group from the menu. For example, I have US/ASCII, Russian and Ukrainian
layouts configured. Most of the time I use either US/ASCII or Russian
layout and switch back and forth between them without activating the
rarely needed Ukrainian layout. But sometimes I need to write something
in Ukrainian, so I select this layout from the tray icon's menu. When
"Toggle mode" is on, the two most recently used groups will be marked
with an asterisk in the KKBSwitch tray icon's menu.


DCOP Bindings
---------------

As of version 0.2, KKBSwitch can be manipulated programmatically with
DCOP. It exports an interface named KBSwitchIntf.
The interfaces offers the following methods:
- int getNumKbdGroups() returns the number of configured keyboard
  groups (layouts)
- ASYNC selectNextGroup() does the same thing as clicking on the
  KKBSwitch's tray icon, i.e. makes the next keyboard group active.
  If in "toggle mode", toggles between the two recently used ones, just
  like clicking on the tray icon does.
- ASYNC selectGroup(int groupno) makes the group whose number is
  groupno active (like selecting a group from the tray icon popup menu)
- TQStringList getGroupNames() returns the list of the keyboard group
  names as configured in XKeyboard.

.

Contributing
--------------

If you wish to contribute to kkbswitch, you might do so:

- TDE Gitea Workspace (TGW) collaboration tool.
  https://mirror.git.trinitydesktop.org/gitea

- TDE Weblate Translation Workspace (TWTW) collaboration tool.
  https://mirror.git.trinitydesktop.org/weblate


Translations status
---------------------

### messages
[![Translations status](https://mirror.git.trinitydesktop.org/weblate/widgets/applications/-/kkbswitch/multi-auto.svg
"Engage in translating")](https://mirror.git.trinitydesktop.org/weblate/projects/applications/kkbswitch/)

### desktop files
[![Translations status](https://mirror.git.trinitydesktop.org/weblate/widgets/applications/-/kkbswitch-kkbswitchdesktop/multi-auto.svg
"Engage in translating")](https://mirror.git.trinitydesktop.org/weblate/projects/applications/kkbswitch-kkbswitchdesktop/)
