/***************************************************************************
                          boldlistboxitem.cpp  -  description
                             -------------------
    begin                : ??? ??? 12 2003
    copyright            : (C) 2003 by Leonid Zeitlin
    email                : lz@europe.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "boldlistboxitem.h"
#include <tqpainter.h>

BoldListBoxItem::BoldListBoxItem(TQListBox *listbox, const TQPixmap &pix,
  const TQString &text, bool bold)
  : TQListBoxPixmap(listbox, pix, text), m_bold(bold)
{
}

BoldListBoxItem::~BoldListBoxItem()
{
}

void BoldListBoxItem::paint(TQPainter *painter)
{
	if (m_bold) {
		TQFont font = painter->font();
		font.setBold(true);
		painter->setFont(font);
	}
	TQListBoxPixmap::paint(painter);	
}
