/***************************************************************************
 *   Copyright (C) 2004 by Leonid Zeitlin                                  *
 *   lz@europe.com                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
    /* Created 04.05.2004 */
    
#ifndef WINDOWWATCHER_H
#define WINDOWWATCHER_H

#include <tqobject.h>

class KBConfig;
class KWinModule;

/**
@author Leonid Zeitlin
This class watches for active window changes and notifies KKBSwitch 
that the keyboard group needs to be canged
*/
class WindowWatcher : public TQObject {
  TQ_OBJECT
protected:
  KBConfig *m_kbconf;
  KWinModule *m_twin_module;
protected slots:    
  virtual void windowAdded(WId id) = 0;
  virtual void windowRemoved(WId id) = 0;
  virtual void activeWindowChanged(WId id) = 0;
public:
  WindowWatcher(KBConfig *kbconf, TQObject *parent = 0, const char *name = 0);
  ~WindowWatcher();
  virtual void changeGroup(int groupno, int next_groupno) = 0;
  virtual void reset() = 0;
signals:
  void windowChanged(int groupno, int next_groupno);
};

#endif
