 /***************************************************************************
 *   Copyright (C) 2005 by Christian Hubinger   *
 *   e9806056@student.tuwien.ac.at   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include "iptchecker.h"

#include "kmfiptinterface.h"
#include <kdebug.h>
#include <tdeapplication.h>
#include <tdelocale.h>
#include <tdemessagebox.h>

#include <dcopobject.h>
#include <dcopclient.h>



KMFIPTInterface::KMFIPTInterface() : DCOPObject("KMFIPTInterface")
{
	kdDebug() << "Starting new service... " << endl;
	m_List = TQStringList();
}

KMFIPTInterface::~KMFIPTInterface()
{
	kdDebug() << "Going away... " << endl;
}

TQString KMFIPTInterface::string(int idx)
{
	return *m_List.at(idx);
}

TQStringList KMFIPTInterface::list()
{
	return m_List;
}

void KMFIPTInterface::add(TQString arg)
{
	kdDebug() << "Adding " << arg << " to the list" << endl;
	m_List << arg;
}

bool KMFIPTInterface::remove(TQString arg)
{
	TQStringList::Iterator it = m_List.find(arg);
	if (it != m_List.end())
	{
		m_List.remove(it);
	}
	else
		return false;
	return true;
}

bool KMFIPTInterface::exit()
{
	tdeApp->quit();
	return 0;
}

void KMFIPTInterface::Test() {
	KMessageBox::information(0 , i18n("Called KMFIPTInterface::Test()") );
}

int KMFIPTInterface::numRulesInChain( TQString table , TQString chain ) {
	IPTChecker *chk = new IPTChecker();
	char *ctable = strdup(table);
	char *cchain = strdup(chain);
	return chk->numRulesInChain( ctable, cchain );
}

int KMFIPTInterface::numChainsInTable( TQString table ) {
	IPTChecker *chk = new IPTChecker();
	char *ctable = strdup(table);
	return chk->numChainsInTable( ctable );
}

TQStringList KMFIPTInterface::getChainsInTable( TQString table ) {
	IPTChecker *chk = new IPTChecker();
	char *ctable = strdup(table);
	return chk->getChainsInTable( ctable );
}

TQStringList KMFIPTInterface::getRuleProperties( TQString table , TQString chain , int index ) {
	IPTChecker *chk = new IPTChecker();
	char *ctable = strdup(table);
	char *cchain = strdup(chain);
	return chk->getRuleProperties( ctable, cchain, index );
}

TQString KMFIPTInterface::getChainPolicy( TQString table , TQString chain ) {
	IPTChecker *chk = new IPTChecker();
	char *ctable = strdup(table);
	char *cchain = strdup(chain);
	return chk->getChainPolicy( ctable, cchain );
}

