//
// C++ Interface: kmfpfcompiler
//
// Description:
//
//
// Author: Christian Hubinger <e9806056@student.tuwien.ac.at>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KMFPFCOMPILER_H
#define KMFPFCOMPILER_H

#include "../../core/kmfcompilerinterface.h"

/**
@author Christian Hubinger
*/

// TQt includes
#include <tqstring.h>
#include <tqobject.h>
#include <tqvaluelist.h>

// KDE includes
#include <tdeparts/part.h>
#include <tdeparts/plugin.h>
#include <tdeparts/factory.h>
#include <kxmlgui.h>

// Project includes
#include "../../core/kmfplugin.h"
#include "../../core/kmfcompilerinterface.h"


class TDEInstance;
namespace KMF {
class KMFGenericDoc;
class KMFIPTDoc;
class KMFNetZone;
class IPTChain;



class KMFPFCompiler :  public KMFPlugin, public virtual KMFCompilerInterface {
	TQ_OBJECT
  
public:
	KMFPFCompiler( TQObject* parent, const char* name );
	~KMFPFCompiler();
	void compile();
	const TQString& compile( KMFGenericDoc* );
	const TQString& osName();
	const TQString& osGUIName();
	const TQString& backendName();
	const TQString& backendGUIName();

private:
	void setupInAndOutHosts( KMFNetZone*,  const TQString& );
	void setupForbiddenHosts( KMFNetZone*, const TQString&  );
	void setupICMPRules( KMFGenericDoc* );
	void setupLocalhostRules();
	void setupPolicies( KMFGenericDoc* );
	void setupNatRules( KMFGenericDoc* );
	void createIncommingACCESSRules( KMFNetZone*, KMFGenericDoc* );
	void createOutgoingACCESSRules( KMFNetZone*, KMFGenericDoc* );
	
	TQString getPortList( TQValueList<int>& );
	
	
// 	void addToChains( KMFNetZone*, KMFIPTDoc* , IPTChain*, const TQString& );
// 	void createRules( KMFNetZone*, IPTChain*, const TQString& );
// 	void setupLocalhostRules(  KMFGenericDoc*, KMFIPTDoc* );
// 	void setupConnectionTracking( KMFIPTDoc* );
// 	void setupPolicies( KMFGenericDoc*, KMFIPTDoc* );
// 	void createZoneProtocolRules( IPTChain*, KMFProtocolUsage* );
// 	void createZoneProtocol( IPTChain*, KMFProtocolUsage* prot , const TQString& option, const TQString& ports );
// 	void createHostProtocolRules( IPTChain*, KMFNetHost*, KMFProtocolUsage*, const TQString& );
// 	void createHostProtocol( IPTChain*, KMFNetHost*, KMFProtocolUsage* prot , const TQString& option, const TQString&, const TQString& );
// 	
// 	void setupForbiddenHosts( KMFIPTDoc*, KMFNetZone*, const TQString&  );
// 	
// 	void setupICMPRules( KMFGenericDoc*, KMFIPTDoc* );
// 	
// 	void setupNatRules( KMFGenericDoc*, KMFIPTDoc* );
// 	void setupNatTarget( KMFGenericDoc*, IPTRule* );
// 	void setupLogging( KMFGenericDoc*, KMFIPTDoc* );
// 	void setupLoggingRules( KMFGenericDoc*, IPTChain* );


private:
	KMFGenericDoc *m_doc;
	TQString m_compiledScript;
	
	TQString m_osName;
	TQString m_osGUIName;
	TQString m_backendName;
	TQString m_backendGUIName;


private slots:
	void slotExportPF();
	
	
	
	
	
// 	void slotShowPFScript();
};





class KMFPFCompilerFactory : public KLibFactory {
	TQ_OBJECT
  
public:
	KMFPFCompilerFactory( TQObject *parent = 0, const char *name = 0 );
	virtual ~KMFPFCompilerFactory() {
/* 		delete s_instance; */
	};
	virtual TQObject* createObject( TQObject* parent = 0, const char* pname = 0,
	                               const char* name = "TQObject",
	                               const TQStringList &args = TQStringList() );
	/*     static TDEInstance* instance(); */

/*private:
	static TDEInstance* s_instance;*/
};
}


#endif
