/***************************************************************************
                          kgpgkeyselectiondlg.cpp
                             -------------------
    copyright            : (C) 2008 by Thomas Baumgart
    email                : ipwizard@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// ----------------------------------------------------------------------------
// TQt Includes

#include <tqlayout.h>
#include <tqlabel.h>
#include <tqwhatsthis.h>

// ----------------------------------------------------------------------------
// TDE Includes

#include <tdelocale.h>
#include <keditlistbox.h>
#include <kled.h>

// ----------------------------------------------------------------------------
// Project Includes

#include "kgpgkeyselectiondlg.h"
#include <kmymoney/kgpgfile.h>

KGpgKeySelectionDlg::KGpgKeySelectionDlg(TQWidget *parent, const char *name) :
  KDialogBase(parent, name, true, i18n("Select additional keys"), Ok | Cancel),
  m_needCheckList(true),
  m_listOk(false),
  m_checkCount(0)
{
  TQWidget* page = new TQWidget(this);
  setMainWidget(page);
  TQVBoxLayout* topLayout = new TQVBoxLayout(page, 0, spacingHint());

  m_listBox = new KEditListBox(page);
  m_listBox->setTitle(i18n("User identification"));
  m_listBox->setButtons( int( KEditListBox::Remove | KEditListBox::Add ) );
  TQWhatsThis::add( m_listBox, i18n( "Enter the id of the key you want to use for data encryption. This can either be an e-mail address or the hexadecimal key id. In case of the key id don't forget the leading 0x." ) );

  topLayout->addWidget(m_listBox);

  // add a LED for the availability of all keys
  TQHBoxLayout* ledBox = new TQHBoxLayout(0, 0, 6, "ledBoxLayout");
  m_keyLed = new KLed(page);
  m_keyLed->setShape( KLed::Circular );
  m_keyLed->setLook( KLed::Sunken );

  ledBox->addWidget(m_keyLed);
  ledBox->addWidget(new TQLabel(i18n("Keys for all of the above user ids found"), page));
  ledBox->addItem(new TQSpacerItem( 50, 20, TQSizePolicy::Expanding, TQSizePolicy::Minimum ));

  topLayout->addLayout(ledBox);

  connect(m_listBox, TQ_SIGNAL(changed()), this, TQ_SLOT(slotIdChanged()));
  connect(m_listBox, TQ_SIGNAL(added(const TQString&)), this, TQ_SLOT(slotKeyListChanged()));
  connect(m_listBox, TQ_SIGNAL(removed(const TQString&)), this, TQ_SLOT(slotKeyListChanged()));
}

void KGpgKeySelectionDlg::setKeys(const TQStringList& list)
{
  m_listBox->clear();
  m_listBox->insertStringList(list);
  slotKeyListChanged();
}

#if 0
void KGpgKeySelectionDlg::slotShowHelp(void)
{
  TQString anchor = m_helpAnchor[m_criteriaTab->currentPage()];
  if(anchor.isEmpty())
    anchor = TQString("details.search");

  tdeApp->invokeHelp(anchor);
}
#endif

void KGpgKeySelectionDlg::slotKeyListChanged(void)
{
  m_needCheckList = true;
  slotIdChanged();
}

void KGpgKeySelectionDlg::slotIdChanged(void)
{
  // this looks a bit awkward. Here's why: KGPGFile::keyAvailable() starts
  // an external task and processes UI events while it waits for the external
  // process to finish. Thus, the first time we get here, the external process
  // is started and the user may press a second key which calls this routine
  // again.
  //
  // The second invocation is counted, but the check is not started until the
  // first one finishes. Once the external process finishes, we check if we
  // were called in the meantime and restart the check.
  if(++m_checkCount == 1) {
    while(1) {
      // first we check the current edit field if filled
      bool keysOk = true;
      if(!m_listBox->currentText().isEmpty()) {
        keysOk = KGPGFile::keyAvailable(m_listBox->currentText());
      }

      // if it is available, then scan the current list if we need to
      if(keysOk) {
        if(m_needCheckList) {
          TQStringList keys = m_listBox->items();
          TQStringList::const_iterator it_s;
          for(it_s = keys.begin(); keysOk && it_s != keys.end(); ++it_s) {
            if(!KGPGFile::keyAvailable(*it_s))
              keysOk = false;
          }
          m_listOk = keysOk;
          m_needCheckList = false;

        } else {
          keysOk = m_listOk;
        }
      }

      // did we receive some more requests to check?
      if(m_checkCount > 1) {
        m_checkCount = 1;
        continue;
      }

      m_keyLed->setState(static_cast<KLed::State>(keysOk && (m_listBox->items().count() != 0) ? KLed::On : KLed::Off));
      enableButtonOK((m_listBox->items().count() == 0) || (m_keyLed->state() == KLed::On));
      break;
    }

    --m_checkCount;
  }
}


#include "kgpgkeyselectiondlg.moc"
