/* This file is part of KNemo
   Copyright (C) 2004, 2005, 2006 Percy Leonhardt <percy@eris23.de>

   KNemo is free software; you can redistribute it and/or modify
   it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   KNemo is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef CONFIGDIALOG_H
#define CONFIGDIALOG_H

#include <tqdict.h>
#include <tqpair.h>
#include <tqstring.h>
#include <tqlistview.h>

#include <tdecmodule.h>

#include "data.h"

class TQTimer;
class ConfigDlg;
class KNemoCheckListItem;

/**
 * This is the configuration dialog for KNemo
 * It is implemented as a control center module so that it is still
 * possible to configure KNemo even when there is no icon visible
 * in the system tray.
 *
 * @short Configuration dialog for KNemo
 * @author Percy Leonhardt <percy@eris23.de>
 */

class ConfigDialog : public TDECModule
{
    TQ_OBJECT
  
public:
    /**
     * Default Constructor
     */
    ConfigDialog( TQWidget *parent, const char *name, const TQStringList& );

    /**
     * Default Destructor
     */
    virtual ~ConfigDialog();

    void load();
    void save();
    void defaults();

private slots:
    void buttonNewSelected();
    void buttonDeleteSelected();
    void buttonAddCommandSelected();
    void buttonRemoveCommandSelected();
    void buttonCommandUpSelected();
    void buttonCommandDownSelected();
    void buttonAddToolTipSelected();
    void buttonRemoveToolTipSelected();
    void buttonNotificationsSelected();
    void buttonStatisticsDirSelected();
    void interfaceSelected( const TQString& interface );
    void aliasChanged( const TQString& text );
    void iconSetChanged( int set );
    void backendChanged( int set );
    void checkBoxNotConnectedToggled( bool on );
    void checkBoxNotExistingToggled( bool on );
    void checkBoxStatisticsToggled( bool on );
    void checkBoxStartKNemoToggled( bool on );
    void spinBoxTrafficValueChanged( int value );
    void checkBoxCustomToggled( bool on );
    void listViewCommandsSelectionChanged();
    void listViewCommandsCheckListItemChanged( KNemoCheckListItem* item, bool state );
    void listViewCommandsRenamed( TQListViewItem* item, int col, const TQString & text );

    /**
     * These three are generic.
     * They are used for all plotter settings to activate the
     * 'Apply' button when something was changed by the user.
     */
    void checkBoxToggled( bool );
    void spinBoxValueChanged( int );
    void kColorButtonChanged( const TQColor& );

private:
    void setupToolTipTab();
    void setupToolTipArray();
    void updateStatisticsEntries( void );

    enum IconSet
    {
        MONITOR = 0,
        MODEM,
        NETWORK,
        WIRELESS
    };

    int mToolTipContent;
    bool mLock;
    ConfigDlg* mDlg;
    TQColor mColorVLines;
    TQColor mColorHLines;
    TQColor mColorIncoming;
    TQColor mColorOutgoing;
    TQColor mColorBackground;
    TQDict<InterfaceSettings> mSettingsDict;
    TQPair<TQString, int> mToolTips[25];

    static const TQString ICON_DISCONNECTED;
    static const TQString ICON_CONNECTED;
    static const TQString ICON_INCOMING;
    static const TQString ICON_OUTGOING;
    static const TQString ICON_TRAFFIC;
    static const TQString SUFFIX_PPP;
    static const TQString SUFFIX_LAN;
    static const TQString SUFFIX_WLAN;
};

class KNemoCheckListItem : public TQObject, public TQCheckListItem
{
    TQ_OBJECT
  
public:
    KNemoCheckListItem( TQListView* view )
        : TQCheckListItem( view, TQString(), TQCheckListItem::CheckBox )
    {}

signals:
    void stateChanged( KNemoCheckListItem*, bool );

protected:
    void stateChange( bool state )
    {
        emit stateChanged( this, state );
    }
};

#endif // CONFIGDIALOG_H
