/***************************************************************************
                          knutrwvar.cpp  -  description
                             -------------------
    begin                : So rj 26 2002
    copyright            : (C) 2002 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

 
#include "knutrwvar.h"
#include "knutvardata.h"
#include "knutprintupsvar.h"

#include <tdeapplication.h>
#include <kcombobox.h>
#include <tdemessagebox.h>
#include <tdelocale.h>

#include <tqframe.h>
#include <tqlabel.h>
#include <tqstring.h>
#include <tqlayout.h>


//#include <iostream>

KNutRWVar::KNutRWVar(TQString* userName, TQString* userPassword, const TQString uName, const TQString password, KNutNet* const initUpsNet, TQWidget* parent, const char* name, const bool modal)
: KDialogBase(Plain, i18n("RW variables"),Ok|Cancel|Default,Ok, parent, name, modal, true), m_upsNet(initUpsNet){
  upsVarDef upsVar;

//  int error;

  if (m_upsNet->getState() != KNutNet::Connected) {
    KNutVarData::showError (KNutNet::NotConnection);
    m_upsConnectOk = false;
    }
  else {
    m_oldUserName = userName;
    m_oldUserPassword = userPassword;

    m_upsConnectOk = true;
    TQFrame *page = plainPage();
    TQVBoxLayout *topLayout = new TQVBoxLayout( page, 0, spacingHint() );
    TQLabel *label1 = new TQLabel (i18n("SET RW VARIABLE"),page,"label1");
    label1->setAlignment(TQt::AlignHCenter);
    topLayout->addWidget(label1);


    TQLabel *label2 = new TQLabel (i18n("Variable:"),page,"label2");
    m_rWVarBox = new KComboBox(page,"rwvarbox");

    TQLabel *label3 = new TQLabel (i18n("Value:"),page,"label2");
    m_valueVarBox = new KComboBox(page,"valuevarbox");
    m_valueVarLine = new KLineEdit(page,"valuevarLine");
    m_valueVarLine->hide();

    m_passLayout = new TQGridLayout (4,2,5,"passLayout");
    TQLabel *labelName = new TQLabel (i18n("User name:"),page,"labelName");
    TQLabel *labelPassword = new TQLabel (i18n("Password:"),page,"labelPassword");
    m_lineEditName = new KLineEdit( page, "LineEditName" );
    m_lineEditPassword = new KLineEdit( page, "LineEditName" );


    if (((*m_oldUserName) == "") && ((*m_oldUserPassword) == "")) {
      m_lineEditName->setText(uName);
      m_lineEditPassword->setText(password);
      }
    else {
      m_lineEditName->setText(*m_oldUserName);
      m_lineEditPassword->setText(*m_oldUserPassword);
      }

    if (!((*m_oldUserName) == "") || !((*m_oldUserPassword) == "")) {
      m_lineEditName->setDisabled(true);
      m_lineEditPassword->setDisabled(true);
      }

    m_lineEditPassword->setEchoMode(TQLineEdit::Password);

    topLayout->addLayout(m_passLayout);

    m_passLayout->addWidget(label2,0,0);
    m_passLayout->addWidget(m_rWVarBox,0,1);
    m_passLayout->addWidget(label3,1,0);
    m_passLayout->addWidget(labelName,2,0);
    m_passLayout->addWidget(labelPassword,3,0);
    m_passLayout->addWidget(m_lineEditName,2,1);
    m_passLayout->addWidget(m_lineEditPassword,3,1);

    topLayout->addStretch(10);
   //loads ComboBox
    int n;
    if (( n = (m_upsNet->readNumberVars( KNutNet::RWVars )+1)) > 1 ) { // zvetsime si pocet o 1
      for (int i =1; i < n ; i++) {
        if (!m_upsNet->readVars(i, upsVar,KNutNet::RWVars))
          m_rWVarBox->insertItem(upsVar.upsVarName);
        }
      slotChangeVar(0);
      }
    else {
      m_passLayout->addWidget(m_valueVarLine,1,1);
      m_valueVarLine->setMaxLength(upsVar.upsVarMax);
      m_valueVarBox->hide();
      m_valueVarLine->show();
      m_upsValueType=true;
      }
    connect (m_rWVarBox,TQ_SIGNAL(activated(int)),this,TQ_SLOT(slotChangeVar(int)));
    }
  }

int KNutRWVar::findItem(const KComboBox *myBox, const TQString text) {
  int n;

  if ((n=myBox->count())) {
    for (int i =0; i < n; i++)
      if (text == myBox->text(i)) return i;
    }
  return myBox->currentItem();  
  }


void KNutRWVar::slotDefault () {
  upsVarDef upsVar;
  int error;

  TQString varName = m_rWVarBox->currentText();
  if (!( error = m_upsNet->readVars(varName,upsVar))) {
    if (upsVar.upsValueType) m_valueVarLine->setText(upsVar.upsValue);
    else m_valueVarBox->setCurrentItem(upsVar.upsValue);
    }
  else KNutVarData::showError (error);
  }


void KNutRWVar::slotChangeVar(int item) {
  upsVarDef upsVar;

  TQString varName = m_rWVarBox->text(item);
  int error = m_upsNet->readVars(varName,upsVar);
  m_upsValueType=upsVar.upsValueType;
  if (error || (upsVar.upsValueType)) {
    // char
    m_valueVarBox->hide();
    m_valueVarLine->show();
    m_passLayout->addWidget(m_valueVarLine,1,1);
    m_valueVarLine->setText(upsVar.upsValue);
    }
  else {
    //enum
    m_valueVarLine->hide();
    m_valueVarBox->show();
    m_passLayout->addWidget(m_valueVarBox,1,1);
    m_valueVarBox->clear();
    if (upsVar.upsVarMax) {
      for (int i = 0 ; i < upsVar.upsVarMax; i++)
        m_valueVarBox->insertItem(m_upsNet->readEnumValueVar(upsVar.upsVarName,i+1));
      }
    m_valueVarBox->setCurrentItem(upsVar.upsValue);
    }
  }



KNutRWVar::~KNutRWVar(){
}

bool KNutRWVar::upsOk (void) { return m_upsConnectOk; }


void KNutRWVar::slotOk() {
  TQString value;
  int error =0;
  if (m_upsValueType) value=m_valueVarLine->text();
  else value=m_valueVarBox->currentText();

  if (((*m_oldUserName) == "") && ((*m_oldUserPassword) == "")) {
    //the first connection sets name and password
    //prvni propojeni nastavime jmeno a heslo
    if (!(error = m_upsNet->setVariable(m_rWVarBox->currentText(), value, m_lineEditName->text(),m_lineEditPassword->text(),false))) {
      // vzhledem k asynchronimu spracovani asi zbytecne
//      myUpsNet->getUpsValues(true);
      emit signalChangeRWVars(m_rWVarBox->currentText());//emits command for loading of variable and repaint of panel

      (*m_oldUserName) = m_lineEditName->text();
      (*m_oldUserPassword) = m_lineEditPassword->text();
      accept();
      }
    }
  else {
    if (((*m_oldUserName) == m_lineEditName->text()) && ((*m_oldUserPassword) == m_lineEditPassword->text())) {
      if (!(error = m_upsNet->setVariable(m_rWVarBox->currentText(), value, m_lineEditName->text(),m_lineEditPassword->text(),true))) {
      // next line isn't needed, maybe
      // vzhledem k asynchronimu spracovani asi zbytecne
//        myUpsNet->getUpsValues(true);
        emit signalChangeRWVars(m_rWVarBox->currentText()); //emits command for loading of variable and repaint of panel
        accept();
        }
      }
    }
  //Nahlasime chybu
  // sends information about error
  if (error) KNutVarData::showError (error);
  }

#include "knutrwvar.moc"
