/*
 *  Copyright (c) 2005 Adrian Page <adrian@pagenet.plus.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef KIS_OPENGL_CANVAS_H_
#define KIS_OPENGL_CANVAS_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_GL

#include <tqwidget.h>
#include <tqgl.h>

#include "kis_global.h"
#include "kis_canvas.h"

#ifdef Q_MOC_RUN
#define TQ_WS_X11
#endif // Q_MOC_RUN

#ifdef TQ_WS_X11
#include <X11/Xlib.h>
#endif // TQ_WS_X11

#define KisOpenGLCanvasFormat (TQGL::DoubleBuffer|TQGL::Rgba|TQGL::DirectRendering|TQGL::NoDepthBuffer)

class KisOpenGLCanvasWidget : public virtual TQGLWidget, public virtual KisCanvasWidget {
public:
    KisOpenGLCanvasWidget(TQWidget *parent, const char *name, TQGLWidget *sharedContextWidget);
    ~KisOpenGLCanvasWidget();

    virtual KisCanvasWidgetPainter *createPainter();

#if defined(EXTENDED_X11_TABLET_SUPPORT)
    virtual void selectTabletDeviceEvents();
#endif

protected:
    virtual void paintEvent(TQPaintEvent *event);
    virtual void mousePressEvent(TQMouseEvent *event);
    virtual void mouseReleaseEvent(TQMouseEvent *event);
    virtual void mouseDoubleClickEvent(TQMouseEvent *event);
    virtual void mouseMoveEvent(TQMouseEvent *event);
    virtual void tabletEvent(TQTabletEvent *event);
    virtual void enterEvent(TQEvent *event );
    virtual void leaveEvent(TQEvent *event);
    virtual void wheelEvent(TQWheelEvent *event);
    virtual void keyPressEvent(TQKeyEvent *event);
    virtual void keyReleaseEvent(TQKeyEvent *event);
    virtual void dragEnterEvent(TQDragEnterEvent *event);
    virtual void dropEvent(TQDropEvent *event);
#ifdef TQ_WS_X11
    bool x11Event(XEvent *event);
#endif // TQ_WS_X11
};
#endif // HAVE_GL

#endif // KIS_OPENGL_CANVAS_H_

