/* This file is part of the KDE project
   Made by Tomislav Lukman (tomislav.lukman@ck.tel.hr)
   Copyright (C) 2002 - 2005, The Karbon Developers

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include <tqlabel.h>
#include <tqlayout.h>
#include <tqtabwidget.h>
#include <tqwidget.h>
#include <tqcolor.h>
#include <tqtooltip.h>
#include <tqevent.h>
#include <tqptrlist.h>

#include <tdelocale.h>
#include <KoMainWindow.h>

#include "karbon_part.h"
#include "karbon_view.h"
#include "karbon_factory.h"
#include "karbon_resourceserver.h"
#include "vcolor.h"
#include "vcolorslider.h"
#include "vselection.h"
#include "vfillcmd.h"
#include "vstrokecmd.h"
#include "vcommand.h"
#include "vobject.h"

#include "vcolordocker.h"

#include <ko_hsv_widget.h>
#include <ko_cmyk_widget.h>
#include <ko_rgb_widget.h>
#include <koColor.h>

#include <kdebug.h>

VColorDocker::VColorDocker( KarbonPart* part, KarbonView* parent, const char* /*name*/ )
	: TQWidget(), m_part ( part ), m_view( parent )
{
	m_isStrokeDocker = false;
	setCaption( i18n( "Color Chooser" ) );

	m_opacity = 1;

	m_fillCmd = 0;
	m_strokeCmd = 0;

	mTabWidget = new TQTabWidget( this );

	/* ##### HSV WIDGET ##### */
	mHSVWidget = new KoHSVWidget( mTabWidget );
	connect( mHSVWidget, TQ_SIGNAL( sigFgColorChanged( const TQColor &) ), this, TQ_SLOT( updateFgColor( const TQColor &) ) );
	connect( mHSVWidget, TQ_SIGNAL( sigBgColorChanged( const TQColor &) ), this, TQ_SLOT( updateBgColor( const TQColor &) ) );
	connect(this, TQ_SIGNAL(fgColorChanged(const TQColor &)), mHSVWidget, TQ_SLOT(setFgColor(const TQColor &)));
	connect(this, TQ_SIGNAL(bgColorChanged(const TQColor &)), mHSVWidget, TQ_SLOT(setBgColor(const TQColor &)));
	connect( mHSVWidget, TQ_SIGNAL( sigModeChanged(KDualColorButton::DualColor) ), this, TQ_SLOT( updateMode( KDualColorButton::DualColor ) ) );
	mTabWidget->addTab( mHSVWidget, i18n( "HSV" ) );

	/* ##### RGB WIDGET ##### */
	mRGBWidget = new KoRGBWidget( mTabWidget );
	connect( mRGBWidget, TQ_SIGNAL( sigFgColorChanged( const TQColor &) ), this, TQ_SLOT( updateFgColor( const TQColor &) ) );
	connect( mRGBWidget, TQ_SIGNAL( sigBgColorChanged( const TQColor &) ), this, TQ_SLOT( updateBgColor( const TQColor &) ) );
	connect(this, TQ_SIGNAL(fgColorChanged(const TQColor &)), mRGBWidget, TQ_SLOT(setFgColor(const TQColor &)));
	connect(this, TQ_SIGNAL(bgColorChanged(const TQColor &)), mRGBWidget, TQ_SLOT(setBgColor(const TQColor &)));
	connect( mRGBWidget, TQ_SIGNAL( sigModeChanged(KDualColorButton::DualColor) ), this, TQ_SLOT( updateMode( KDualColorButton::DualColor ) ) );
	mTabWidget->addTab( mRGBWidget, i18n( "RGB" ) );

	/* ##### CMYK WIDGET ##### */
	/*mCMYKWidget = new KoCMYKWidget( mTabWidget );
	connect( mCMYKWidget, TQ_SIGNAL( sigFgColorChanged( const TQColor &) ), this, TQ_SLOT( updateFgColor( const TQColor &) ) );
	connect( mCMYKWidget, TQ_SIGNAL( sigBgColorChanged( const TQColor &) ), this, TQ_SLOT( updateBgColor( const TQColor &) ) );
	mTabWidget->addTab( mCMYKWidget, i18n( "CMYK" ) );*/

	//Opacity
	mOpacity = new VColorSlider( i18n( "Opacity:" ), TQColor( "white" ), TQColor( "black" ), 0, 100, 100, this );
	//TODO: Make "white" a transparent color
	connect( mOpacity, TQ_SIGNAL( valueChanged ( int ) ), this, TQ_SLOT( updateOpacity() ) );
	TQToolTip::add( mOpacity, i18n( "Alpha (opacity)" ) );

	TQVBoxLayout *mainWidgetLayout = new TQVBoxLayout( this, 3 );
	mainWidgetLayout->addWidget( mTabWidget );
	mainWidgetLayout->addWidget( mOpacity );
	mainWidgetLayout->activate();
	setMaximumHeight( 174 );
	setMinimumWidth( 194 );
	
}

VColorDocker::~VColorDocker()
{
}

void VColorDocker::updateFgColor(const TQColor &c)
{
	m_color = c;

	VColor v = VColor(c);
	v.setOpacity( m_opacity );

	// check if we have objects selected
	TQPtrList<VObject> VNewObjectList = m_part->document().selection()->objects();
	if( ! VNewObjectList.count() )
		return;
	
	mHSVWidget->blockSignals(true);
	mRGBWidget->blockSignals(true);
	//mCMYKWidget->blockSignals(true);
	
	VCommandHistory* history = m_part->commandHistory();
	const TQPtrList<VCommand>* commandList = history->commands();
	VStrokeCmd* command = dynamic_cast<VStrokeCmd*>(commandList->getLast());

	if(command == 0 || m_strokeCmd == 0)
	{
		m_strokeCmd = new VStrokeCmd( &m_part->document(), v );
		m_part->addCommand( m_strokeCmd, true );
	}
	else
	{
		TQPtrList<VObject> VOldObjectList = command->getSelection()->objects();

		if( VOldObjectList == VNewObjectList )
		{
			m_strokeCmd->changeStroke(v);
			m_part->repaintAllViews();
		}
		else
		{
			m_strokeCmd = new VStrokeCmd( &m_part->document(), v );
			m_part->addCommand( m_strokeCmd, true );
		}
	}
 
	emit fgColorChanged( c );

	mHSVWidget->blockSignals(false);
	mRGBWidget->blockSignals(false);
	//mCMYKWidget->blockSignals(false);
}

void VColorDocker::updateBgColor(const TQColor &c)
{
	m_color = c;

	VColor v = VColor(c);
	v.setOpacity( m_opacity );
	
	// check if we have objects selected
	TQPtrList<VObject> VNewObjectList = m_part->document().selection()->objects();
	if( ! VNewObjectList.count() )
		return;

	mHSVWidget->blockSignals(true);
	mRGBWidget->blockSignals(true);
	//mCMYKWidget->blockSignals(true);
	
	VCommandHistory* history = m_part->commandHistory();
	const TQPtrList<VCommand>* commandList = history->commands();
	VFillCmd* command = dynamic_cast<VFillCmd*>(commandList->getLast());

	if(command == 0 || m_fillCmd == 0)
	{
		m_fillCmd = new VFillCmd( &m_part->document(), VFill(v) );
		m_part->addCommand( m_fillCmd, true );
	}
	else
	{
		TQPtrList<VObject> VOldObjectList = command->getSelection()->objects();

		if( VOldObjectList == VNewObjectList )
		{
			m_fillCmd->changeFill(VFill(v));
			m_part->repaintAllViews();
		}
		else
		{
			m_fillCmd = new VFillCmd( &m_part->document(), VFill(v) );
			m_part->addCommand( m_fillCmd, true );
		}
	}
 
	emit bgColorChanged( c );

	mHSVWidget->blockSignals(false);
	mRGBWidget->blockSignals(false);
	//mCMYKWidget->blockSignals(false);
}

void VColorDocker::updateOpacity()
{
	m_opacity = mOpacity->value() / 100.0;

	VColor c = VColor(m_color);
	c.setOpacity( m_opacity );

	if ( isStrokeDocker() )
		m_part->addCommand( new VStrokeCmd( &m_part->document(), c ), true );
	else
		m_part->addCommand( new VFillCmd( &m_part->document(), VFill( c ) ), true );
}

void
VColorDocker::mouseReleaseEvent( TQMouseEvent * )
{
	//changeColor();
}

void VColorDocker::setFillDocker()
{
	m_isStrokeDocker = false;
	mHSVWidget->setMode( KDualColorButton::Background );
	mRGBWidget->setMode( KDualColorButton::Background );
	update();
}

void VColorDocker::setStrokeDocker()
{
	m_isStrokeDocker = true;
	mHSVWidget->setMode( KDualColorButton::Foreground );
	mRGBWidget->setMode( KDualColorButton::Foreground );
	update();
}

void VColorDocker::update()
{
	mHSVWidget->blockSignals(true);
	mRGBWidget->blockSignals(true);
	//mCMYKWidget->blockSignals(true);

	int objCnt = m_part->document().selection()->objects().count();

	if( objCnt > 0 )
	{
		VObject *obj = m_part->document().selection()->objects().getFirst();

		TQColor fgColor = TQColor(obj->stroke() ? obj->stroke()->color() : VColor() );
		TQColor bgColor = TQColor(obj->fill() ? obj->fill()->color() : VColor() );

		mHSVWidget->setFgColor(fgColor);
		mRGBWidget->setFgColor(fgColor);
		//mCMYKWidget->setFgColor(fgColor);
			
		mHSVWidget->setBgColor(bgColor);
		mRGBWidget->setBgColor(bgColor);
		//mCMYKWidget->setBgColor(bgColor);

		if( m_isStrokeDocker )
			m_color = fgColor;
		else
			m_color = bgColor;
	}

	mHSVWidget->blockSignals(false);
	mRGBWidget->blockSignals(false);
	//mCMYKWidget->blockSignals(false);
}

void VColorDocker::updateMode( KDualColorButton::DualColor s )
{
	m_isStrokeDocker = (s == KDualColorButton::Foreground);
	update();
	emit modeChanged( s );
}

#include "vcolordocker.moc"

