/*
 *  Copyright (c) 2006 Boudewijn Rempt
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
 
#ifndef COMPOSITE_CMYK
#define COMPOSITE_CMYK

void compositeCopyCyan(TQ_INT32 stride,
               TQ_UINT8 *dst, 
               TQ_INT32 dststride,
               TQ_UINT8 *src, 
               TQ_INT32 srcstride,
               TQ_INT32 rows, 
               TQ_INT32 cols, 
               TQ_UINT8 opacity = OPACITY_OPAQUE)
{
    compositeCopyChannel(PIXEL_CYAN, stride, dst, dststride, src, srcstride, rows, cols, opacity);
}


void compositeCopyMagenta(TQ_INT32 stride,
              TQ_UINT8 *dst, 
              TQ_INT32 dststride,
              TQ_UINT8 *src, 
              TQ_INT32 srcstride,
              TQ_INT32 rows, 
              TQ_INT32 cols, 
              TQ_UINT8 opacity = OPACITY_OPAQUE)
{
    compositeCopyChannel(PIXEL_MAGENTA, stride, dst, dststride, src, srcstride, rows, cols, opacity);

}


void compositeCopyYellow(TQ_INT32 stride,
             TQ_UINT8 *dst, 
             TQ_INT32 dststride,
             TQ_UINT8 *src, 
             TQ_INT32 srcstride,
             TQ_INT32 rows, 
             TQ_INT32 cols, 
             TQ_UINT8 opacity = OPACITY_OPAQUE)
{
    compositeCopyChannel(PIXEL_YELLOW, stride, dst, dststride, src, srcstride, rows, cols, opacity);

}


void compositeCopyBlack(TQ_INT32 stride,
            TQ_UINT8 *dst, 
            TQ_INT32 dststride,
            TQ_UINT8 *src, 
            TQ_INT32 srcstride,
            TQ_INT32 rows, 
            TQ_INT32 cols, 
            TQ_UINT8 opacity = OPACITY_OPAQUE)
{
    compositeCopyChannel(PIXEL_BLACK, stride, dst, dststride, src, srcstride, rows, cols, opacity);
}


#endif
