/***************************************************************************
 *   Copyright (C) 2005 by Daniel Stöckel                                  *
 *   daniel@Docter                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "roundbutton.h"

#include <kiconloader.h>
#include <kpixmapeffect.h>
#include <tqbitmap.h>

#include "kommando.h"

RoundButton::RoundButton( TQWidget* parent, unsigned short rad, const char* name, WFlags f)
    : TQButton(parent, name, f)
{
    setRadius(rad);
    //setBackgroundMode(NoBackground);
    //setBackgroundColor(TQColor(0,0,0));

    background.resize(width(),height());
}

RoundButton::~RoundButton()
{
}

void RoundButton::drawButton( TQPainter *Painter )
{
    Painter->drawPixmap(0,0,background);
    drawButtonLabel(Painter);
}

void RoundButton::drawButtonLabel( TQPainter *Painter )
{
    //Do we have a pixmap?
    if(!pixmap()){
        Painter->drawText(radius,radius,"n/a",5);
    } else {
        Painter->drawPixmap(rect(),*pixmap());
    }
}

void RoundButton::move( int x, int y )
{
    TQButton::move(x-radius,y-radius);
}

void RoundButton::setRadius( int rad )
{
    radius=rad;
    resize(radius*2,radius*2);
    setFixedSize(radius*2,radius*2);
    //setIcon(mIconPath);
}

void RoundButton::setIcon( const TQString& path )
{
    mIconPath=path;
    icon=MainBarIcon(path,radius*2);
    setPixmap(icon);
    setMask(icon.createHeuristicMask());
}

void RoundButton::show()
{
    //get the buttons part of the screenshot
    copyBlt(&background,0,0,static_cast<Kommando*>(parent())->screenshot(),pos().x(),pos().y(),width(),height());

    TQButton::show();
}

bool RoundButton::event( TQEvent * evt )
{
    switch(evt->type()){
        case TQEvent::Enter:
            emit mouseIn(this);
            setActive(true);
            return true;
        case TQEvent::Leave:
            emit mouseOut(this);
            setActive(false);
            return true;
        default:
            return TQButton::event(evt);
    }
}

void RoundButton::setActive( bool mode )
{
    if(mode){
        setPixmap(mEffect.apply(icon,TDEIcon::Desktop,TDEIcon::ActiveState));
    } else {
        setPixmap(mEffect.apply(icon,TDEIcon::Desktop,TDEIcon::DefaultState));
    }
}

//key press events need to be ignored, so that they can be captured by the menu
/* TODO execution could be placed here! */
void RoundButton::keyPressEvent( TQKeyEvent * evt )
{
    evt->ignore();
}

#include "roundbutton.moc"
