/*
  DccTransferManager controls DccTransfer instances.
  All DccTransferRecv/DccTransferSend instances are created and deleted by this class.
  Each DccTransfer instance is deleted immediately after its transfer done.
*/

/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/

/*
  Copyright (C) 2007 Shintaro Matsuoka <shin@shoegazed.org>
*/

#ifndef DCCTRANSFERMANAGER_H
#define DCCTRANSFERMANAGER_H

#include "dcctransfer.h"

#include <tqobject.h>
#include <tqvaluelist.h>


class KURL;

class DccTransferRecv;
class DccTransferSend;

class DccTransferManager : public TQObject
{
    TQ_OBJECT
  

    public:
        DccTransferManager( TQObject* parent = 0 );
        ~DccTransferManager();

    signals:
        /*
         * The status of the item is DccTransfer::Configuring when this signal is emitted.
         */
        void newTransferAdded( DccTransfer* transfer );
        /*
         * The status of the item is DccTransfer::Queued when this signal is emitted.
         */
        void newTransferQueued( DccTransfer* transfer );

        void fileURLChanged( DccTransferRecv* transfer );

    public:
        DccTransferRecv* newDownload();
        DccTransferSend* newUpload();

        /**
         * @return a DccTransferRecv item if applicable one found, otherwise 0.
         */
        DccTransferRecv* resumeDownload(int connectionId, const TQString& partnerNick, const TQString& fileName, const TQString& ownPort, unsigned long position );

        /**
         * @return a DccTransferSend item if applicable one found, otherwise 0.
         */
        DccTransferSend* resumeUpload(int connectionId, const TQString& partnerNick, const TQString& fileName, const TQString& ownPort, unsigned long position );

        DccTransferSend* startReverseSending(int connectionId, const TQString& partnerNick, const TQString& fileName, const TQString& partnerHost, const TQString& partnerPort, unsigned long fileSize, const TQString& token );

        bool isLocalFileInWritingProcess( const KURL& localUrl ) const;

        int generateReverseTokenNumber();

        bool hasActiveTransfers();

    private:
        /*
         * initTransfer() does the common jobs for newDownload() and newUpload()
         */
        void initTransfer( DccTransfer* transfer );

    private slots:
        void slotTransferStatusChanged( DccTransfer* item, int newStatus, int oldStatus );
        void removeSendItem( DccTransfer* item );
        void removeRecvItem( DccTransfer* item );

        void slotSettingsChanged();

    private:
        TQValueList< DccTransferSend* > m_sendItems;
        TQValueList< DccTransferRecv* > m_recvItems;

        int m_nextReverseTokenNumber;
        TQString m_defaultIncomingFolder;  // store here to know if this settings is changed
};

#endif  // DCCTRANSFERMANAGER_H
