/***************************************************************************
*   Copyright (C) 2006 by                                                 *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#include "weightinput.h"

#include <tdelocale.h>

#include "backends/recipedb.h"
#include "datablocks/element.h"
#include "datablocks/weight.h"
#include "prepmethodcombobox.h"

WeightInput::WeightInput( TQWidget *parent, RecipeDB *database, Unit::Type type, MixedNumber::Format format ) : 
  AmountUnitInput(parent,database,type,format),
  m_database(database)
{
	prepMethodBox = new PrepMethodComboBox(false,this,database,i18n("-No Preparation-"));
	prepMethodBox->reload();

	connect( prepMethodBox, TQ_SIGNAL(activated(int)), TQ_SLOT(emitValueChanged()) );
}

void WeightInput::emitValueChanged()
{
	Weight w;
	w.perAmount = amount().toDouble();

	Unit u = unit();
	w.perAmountUnitID = u.id;
	w.perAmountUnit = (w.perAmount>1)?u.plural:u.name;

	Element prep;
	w.prepMethod = prep.name;
	w.prepMethodID = prep.id;
	emit valueChanged( w );
}

void WeightInput::setPrepMethod( const Element &prep )
{
	if ( prep.id == -1 )
		prepMethodBox->setCurrentItem(0);
	else
		prepMethodBox->setSelected( prep.id );

}

Element WeightInput::prepMethod() const
{
	Element prep;
	prep.id = prepMethodBox->id( prepMethodBox->currentItem() );
	if ( prep.id != -1 )
		prep.name = prepMethodBox->currentText();
	return prep;
}

#include "weightinput.moc"
