//
// C++ Implementation: showmaildialog
//
// Description:
//
//
// Author: Ulrich Weigelt <ulrich.weigelt@gmx.de, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "showmaildialog.h"

ShowMailDialog::ShowMailDialog( TQWidget * parent, TQString & caption, bool allowHTML, TQString & sender, TQString & date, TQString & size, TQString & subject, TQString & body ) :
    KDialogBase( parent, "showmaildialog", true, caption, KDialogBase::Ok | KDialogBase::Cancel | KDialogBase::User1, KDialogBase::Ok, true, KGuiItem( i18n( "Reply" ), "mail-reply-sender" ) )
{
  //create main widget
  TQWidget* mainWidget = new TQWidget( this );
  setMainWidget( mainWidget );

  //this layout seperates meta data area (date, subject, and so on) from the mail body area
  TQVBoxLayout* layMain = new TQVBoxLayout( mainWidget, 0, spacingHint() );

  //this layouts arranges the labels and lines for the meta data
  TQHBoxLayout* layMetaDatas = new TQHBoxLayout( layMain, spacingHint() );
  TQVBoxLayout* layLabels = new TQVBoxLayout( layMetaDatas, spacingHint() );
  TQVBoxLayout* layLines = new TQVBoxLayout( layMetaDatas, spacingHint() );

  //create labels for meta data
  TQLabel* lblSender = new TQLabel( i18n( "Sender:" ), mainWidget, "lblSender" );
  layLabels->addWidget( lblSender );

  TQLabel* lblDate = new TQLabel( i18n( "Date:" ), mainWidget, "lblDate" );
  layLabels->addWidget( lblDate );

  TQLabel* lblSize = new TQLabel( i18n( "Size:" ), mainWidget, "lblSize" );
  layLabels->addWidget( lblSize );

  TQLabel* lblSubject = new TQLabel( i18n( "Subject:" ), mainWidget, "lblSubject" );
  layLabels->addWidget( lblSubject );

  //create edit lines to show the meta data
  KLineEdit* liSender = new KLineEdit( sender, mainWidget, "liSender" );
  liSender->setReadOnly( true );
  layLines->addWidget( liSender );

  KLineEdit* liDate = new KLineEdit( date, mainWidget, "liDate" );
  liDate->setReadOnly( true );
  layLines->addWidget( liDate );

  KLineEdit* liSize = new KLineEdit( size, mainWidget, "liSize" );
  liSize->setReadOnly( true );
  layLines->addWidget( liSize );

  KLineEdit* liSubject = new KLineEdit( subject, mainWidget, "liSubject" );
  liSubject->setReadOnly( true );
  layLines->addWidget( liSubject );

  //create text browser for the mail body
  KTextBrowser* txtBody = new KTextBrowser( mainWidget );
  txtBody->setReadOnly( true );

  if( !allowHTML )    //set HTML view or not
    txtBody->setTextFormat( KTextBrowser::PlainText );

  txtBody->setText( body );
  txtBody->setMinimumSize( WIDTH_VIEW_MAILBODY, HEIGHT_VIEW_MAILBODY );

  layMain->addWidget( txtBody );

  //store body, subject and sender for reply (slotUser1())
  m_body = body;
  m_subject = subject;
  m_sender = sender;
}

ShowMailDialog::~ShowMailDialog()
{
}

void ShowMailDialog::slotUser1( )
{
  //make copy of body to manipulate
  TQString body = m_body;

  //add '>' at front of every line
  body.insert( 0, "> " );
  body.replace( "\n", "\n> " );

  //set data of the answer mail
  KURL mail;
  mail.setProtocol( "mailto" );
  mail.setPath( m_sender );
  mail.setQuery( "?subject=" + KURL::encode_string( "Re: " +  m_subject ) + "&body=" + KURL::encode_string( body ) );

  //invoke mailer
  tdeApp->invokeMailer( mail );
}


#include "showmaildialog.moc"
