//
// C++ Implementation: configactions
//
// Description:
//
//
// Author: Ulrich Weigelt <ulrich.weigelt@gmx.de>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "configactions.h"

typedef KGenericFactory<ConfigActions, TQWidget> ConfigActionsFactory;

K_EXPORT_COMPONENT_FACTORY( kcm_kshowmailconfigactions, ConfigActionsFactory(
    "kcm_kshowmailconfigactions" ) );

ConfigActions::ConfigActions( TQWidget * parent, const char * name, const TQStringList & args )
  : TDECModule( ConfigActionsFactory::instance(), parent, args )
{
  //set the module name
  if ( !name )
    setName( "configactions" );

  //build GUI
  //---------

  //main layout
  TQVBoxLayout* layMain = new TQVBoxLayout( this, 0, 10 );

  //two boxes to seperate the action if new mail or if no new mail
  TQGroupBox* gboxNewMails = new TQGroupBox( 0, TQt::Horizontal, i18n( "Action if new &mail" ), this, "gboxNewMails" );
  TQGroupBox* gboxNoNewMails = new TQGroupBox( 2, TQt::Vertical, i18n( "Action if &no mail" ), this, "gboxNoNewMails" );
  gboxNoNewMails->layout()->setSpacing( 20 );
  layMain->addWidget( gboxNewMails );
  layMain->addWidget( gboxNoNewMails );

  //layouts for the upper group box
  TQVBoxLayout* layMainNewMails = new TQVBoxLayout( gboxNewMails->layout(), 10 );
  TQGridLayout* layMainNewMailsTop = new TQGridLayout( layMainNewMails, 2, 2, 10 );
  TQGridLayout* layMainNewMailsDown = new TQGridLayout( layMainNewMails, 2, 4, 10 );

  //items for the upper group box
  chkNewMailsAlertWindow = new TQCheckBox( i18n( "Show message box" ), gboxNewMails, "chkNewMailsAlertWindow" );
  TQToolTip::add( chkNewMailsAlertWindow, i18n( "Show message if new mail arrives" ) );
  layMainNewMailsTop->addWidget( chkNewMailsAlertWindow, 0, 0 );

  chkNewMailsMainWindow = new TQCheckBox( i18n( "Show main window" ), gboxNewMails, "chkNewMailsMainWindow" );
  TQToolTip::add( chkNewMailsMainWindow, i18n( "Show main window if new mail arrives" ) );
  layMainNewMailsTop->addWidget( chkNewMailsMainWindow, 0, 1 );

  chkNewMailsBeep = new TQCheckBox( i18n( "&Beep" ), gboxNewMails, "chkNewMailsBeep" );
  TQToolTip::add( chkNewMailsBeep, i18n( "Beeps the internal speaker if new mail" ) );
  layMainNewMailsTop->addWidget( chkNewMailsBeep, 1, 0 );

  chkNewMailsSound = new TQCheckBox( i18n( "Sound:" ), gboxNewMails, "chkNewMailsSound" );
  TQToolTip::add( chkNewMailsSound, i18n( "Plays sound if new mail" ) );
  layMainNewMailsDown->addWidget( chkNewMailsSound, 0, 0 );

  btnNewMailsPlaySound = new KPushButton( KGuiItem( TQString(), TQString( "media-playback-start" ), i18n( "Play the selected sound file" ), i18n( "Play the selected sound file" ) ), gboxNewMails, "btnNewMailsPlaySound" );
  layMainNewMailsDown->addWidget( btnNewMailsPlaySound, 0, 1 );

  txtNewMailsSound = new KLineEdit( gboxNewMails, "txtNewMailsSound" );
  layMainNewMailsDown->addWidget( txtNewMailsSound, 0, 2 );

  btnNewMailsChooseSound = new KPushButton( KGuiItem( TQString(), TQString( "folder" ), i18n( "Press to select sound file" ), i18n( "Press to select sound file" ) ), gboxNewMails, "btnNewMailsChooseSound" );
  layMainNewMailsDown->addWidget( btnNewMailsChooseSound, 0, 3 );

  chkNewMailsCommand = new TQCheckBox( i18n( "Command:" ), gboxNewMails, "chkNewMailsCommand" );
  TQToolTip::add( chkNewMailsCommand, i18n( "Starts external program if new mail" ) );
  layMainNewMailsDown->addWidget( chkNewMailsCommand, 1, 0 );

  btnNewMailsExecCommand = new KPushButton( KGuiItem( TQString(), TQString( "application-x-executable" ), i18n( "Start the selected program" ), i18n( "Start the selected program" ) ), gboxNewMails, "btnNewMailsExecCommand" );
  layMainNewMailsDown->addWidget( btnNewMailsExecCommand, 1, 1 );

  txtNewMailsCommand = new KLineEdit( gboxNewMails, "txtNewMailsCommand" );
  layMainNewMailsDown->addWidget( txtNewMailsCommand, 1, 2 );

  btnNewMailsChooseCommand = new KPushButton( KGuiItem( TQString(), TQString( "folder" ), i18n( "Select external command" ), i18n( "Select external command" ) ), gboxNewMails, "btnNewMailsChooseCommand" );
  layMainNewMailsDown->addWidget( btnNewMailsChooseCommand, 1, 3 );

  //items for the lower group box
  chkNoNewMailsMinimize = new TQCheckBox( i18n( "Minimi&ze" ), gboxNoNewMails, "chkNoNewMailsMinimize" );
  TQToolTip::add( chkNoNewMailsMinimize, i18n( "Minimize window if no new mail" ) );

  chkNoNewMailsTerminate = new TQCheckBox( i18n( "Terminate" ), gboxNoNewMails, "chkNoNewMailsTerminate" );
  TQToolTip::add( chkNoNewMailsTerminate, i18n( "Terminate kshowmail if no new mail" ) );

  //connect file choose buttons
  connect( btnNewMailsChooseSound, TQ_SIGNAL( clicked() ), this, TQ_SLOT( slotChooseSound() ) );
  connect( btnNewMailsChooseCommand, TQ_SIGNAL( clicked() ), this, TQ_SLOT( slotChooseCommand() ) );

  //connect test buttons
  connect( btnNewMailsPlaySound, TQ_SIGNAL( clicked() ), this, TQ_SLOT( slotPlaySound() ) );
  connect( btnNewMailsExecCommand, TQ_SIGNAL( clicked() ), this, TQ_SLOT( slotExecuteCommand() ) );

  //connect sound and command check boxes to enable or disable the configuration items
  connect( chkNewMailsSound, TQ_SIGNAL( toggled( bool ) ), this, TQ_SLOT( slotSoundToggled( bool ) ) );
  connect( chkNewMailsCommand, TQ_SIGNAL( toggled( bool ) ), this, TQ_SLOT( slotCommandToggled( bool ) ) );

  //connect all configuration items with slot changed() to notify the dialog about changes
  connect( chkNewMailsAlertWindow, TQ_SIGNAL( toggled( bool ) ), this, TQ_SLOT( slotChanged() ) );
  connect( chkNewMailsMainWindow, TQ_SIGNAL( toggled( bool ) ), this, TQ_SLOT( slotChanged() ) );
  connect( chkNewMailsBeep, TQ_SIGNAL( toggled( bool ) ), this, TQ_SLOT( slotChanged() ) );
  connect( chkNewMailsSound, TQ_SIGNAL( toggled( bool ) ), this, TQ_SLOT( slotChanged() ) );
  connect( chkNewMailsCommand, TQ_SIGNAL( toggled( bool ) ), this, TQ_SLOT( slotChanged() ) );
  connect( txtNewMailsSound, TQ_SIGNAL( textChanged( const TQString& ) ), this, TQ_SLOT( slotChanged() ) );
  connect( txtNewMailsCommand, TQ_SIGNAL( textChanged( const TQString& ) ), this, TQ_SLOT( slotChanged() ) );
  connect( chkNoNewMailsMinimize, TQ_SIGNAL( toggled( bool ) ), this, TQ_SLOT( slotChanged() ) );
  connect( chkNoNewMailsTerminate, TQ_SIGNAL( toggled( bool ) ), this, TQ_SLOT( slotChanged() ) );



  //get application config object (kshowmailrc)
  config = tdeApp->config();

  //load configured values
  load();

}


ConfigActions::~ConfigActions()
{
}

void ConfigActions::load( )
{
  config->setGroup( CONFIG_GROUP_ACTIONS );

  chkNewMailsAlertWindow->setChecked( config->readBoolEntry( CONFIG_ENTRY_NEW_MAIL_ALERTWINDOW, DEFAULT_ACTION_NEW_MAIL_ALERTWINDOW ) );
  chkNewMailsMainWindow->setChecked( config->readBoolEntry( CONFIG_ENTRY_NEW_MAIL_MAINWINDOW, DEFAULT_ACTION_NEW_MAIL_MAINWINDOW ) );
  chkNewMailsBeep->setChecked( config->readBoolEntry( CONFIG_ENTRY_NEW_MAIL_BEEP, DEFAULT_ACTION_NEW_MAIL_BEEP ) );
  chkNewMailsSound->setChecked( config->readBoolEntry( CONFIG_ENTRY_NEW_MAIL_SOUND, DEFAULT_ACTION_NEW_MAIL_SOUND ) );
  chkNewMailsCommand->setChecked( config->readBoolEntry( CONFIG_ENTRY_NEW_MAIL_COMMAND, DEFAULT_ACTION_NEW_MAIL_COMMAND ) );
  chkNoNewMailsTerminate->setChecked( config->readBoolEntry( CONFIG_ENTRY_NO_NEW_MAIL_TERMINATE, DEFAULT_ACTION_NO_NEW_MAIL_TERMINATE ) );
  chkNoNewMailsMinimize->setChecked( config->readBoolEntry( CONFIG_ENTRY_NO_NEW_MAIL_MINIMIZE, DEFAULT_ACTION_NO_NEW_MAIL_MINIMIZE ) );

  txtNewMailsSound->setText( config->readEntry( CONFIG_ENTRY_NEW_MAIL_SOUNDPATH ) );
  txtNewMailsCommand->setText( config->readEntry( CONFIG_ENTRY_NEW_MAIL_COMMANDPATH ) );

  //enable or disable configuration items of sound and command
  slotSoundToggled( chkNewMailsSound->isChecked() );
  slotCommandToggled( chkNewMailsCommand->isChecked() );
}

void ConfigActions::defaults( )
{
  chkNewMailsAlertWindow->setChecked( DEFAULT_ACTION_NEW_MAIL_ALERTWINDOW );
  chkNewMailsMainWindow->setChecked( DEFAULT_ACTION_NEW_MAIL_MAINWINDOW );
  chkNewMailsBeep->setChecked( DEFAULT_ACTION_NEW_MAIL_BEEP );
  chkNewMailsSound->setChecked( DEFAULT_ACTION_NEW_MAIL_SOUND );
  chkNewMailsCommand->setChecked( DEFAULT_ACTION_NEW_MAIL_COMMAND );
  chkNoNewMailsTerminate->setChecked( DEFAULT_ACTION_NO_NEW_MAIL_TERMINATE );
  chkNoNewMailsMinimize->setChecked( DEFAULT_ACTION_NO_NEW_MAIL_MINIMIZE );

  //enable or disable configuration items of sound and command
  slotSoundToggled( chkNewMailsSound->isChecked() );
  slotCommandToggled( chkNewMailsCommand->isChecked() );
}

void ConfigActions::save( )
{
  config->setGroup( CONFIG_GROUP_ACTIONS );
  config->writeEntry( CONFIG_ENTRY_NEW_MAIL_ALERTWINDOW, chkNewMailsAlertWindow->isChecked() );
  config->writeEntry( CONFIG_ENTRY_NEW_MAIL_MAINWINDOW, chkNewMailsMainWindow->isChecked() );
  config->writeEntry( CONFIG_ENTRY_NEW_MAIL_BEEP, chkNewMailsBeep->isChecked() );
  config->writeEntry( CONFIG_ENTRY_NEW_MAIL_SOUND, chkNewMailsSound->isChecked() );
  config->writeEntry( CONFIG_ENTRY_NEW_MAIL_SOUNDPATH, txtNewMailsSound->text() );
  config->writeEntry( CONFIG_ENTRY_NEW_MAIL_COMMAND, chkNewMailsCommand->isChecked() );
  config->writeEntry( CONFIG_ENTRY_NEW_MAIL_COMMANDPATH, txtNewMailsCommand->text() );
  config->writeEntry( CONFIG_ENTRY_NO_NEW_MAIL_TERMINATE, chkNoNewMailsTerminate->isChecked() );
  config->writeEntry( CONFIG_ENTRY_NO_NEW_MAIL_MINIMIZE, chkNoNewMailsMinimize->isChecked() );

  //write configuration to disk
  config->sync();
}

void ConfigActions::slotChooseSound( )
{
  TQString startPath;    //start path of the file dialog

  //get sounds directory of kshowmail
  TDEStandardDirs stdDirs;
  TQString soundPath = stdDirs.findResource( "data", "kshowmail/sounds/" );

  //get start path of the file dialog
  if( txtNewMailsSound->text() != "" )
  {
    startPath = txtNewMailsSound->text();
  }
  else if( soundPath != TQString::null )
  {
    startPath = soundPath;
  }
  else
  {
    startPath = TQString::null;
  }

  //open file dialog
  TQString path = KFileDialog::getOpenFileName( startPath, "*.wav *.ogg|" + i18n( "Sound files (*.wav, *.ogg)" ) + "\n*.*|" + i18n( "All files (*)" ), this, i18n("Select Sound File") );

  //write selected path into the edit line
  if( path != TQString::null )
    txtNewMailsSound->setText( path );
}

void ConfigActions::slotChooseCommand( )
{
  //open file dialog
  TQString path = KFileDialog::getOpenFileName( TQString::null, "", this, i18n("Select external command") );

  //write selected path into the edit line
  if( path != TQString::null )
    txtNewMailsCommand->setText( path );
}

void ConfigActions::slotPlaySound( )
{
  TQString path = txtNewMailsSound->text();

  if( path != TQString::null )
    KAudioPlayer::play( path );
}

void ConfigActions::slotExecuteCommand( )
{
  TQString path = txtNewMailsCommand->text();

  if( path != TQString::null )
  {
    KShellProcess proc;    //process handler to execute the binary

    proc << path;

    proc.start( KShellProcess::DontCare );
  }
}

void ConfigActions::slotSoundToggled( bool on )
{
  btnNewMailsPlaySound->setEnabled( on );
  txtNewMailsSound->setEnabled( on );
  btnNewMailsChooseSound->setEnabled( on );
}

void ConfigActions::slotCommandToggled( bool on )
{
  btnNewMailsExecCommand->setEnabled( on );
  txtNewMailsCommand->setEnabled( on );
  btnNewMailsChooseCommand->setEnabled( on );
}

void ConfigActions::slotChanged( )
{
  TDECModule::changed();
}


#include "configactions.moc"





