/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** TQt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/

void SQ_Filters::init()
{
    listFilters->setSorting(-1);

    TQListViewItem *itemafter = 0L, *item;

    TQValueList<TQString>::iterator nEND = KSquirrel::app()->filtersNames()->end();
    TQValueList<TQString>::iterator it_name = KSquirrel::app()->filtersNames()->begin();
    TQValueList<TQString>::iterator it_ext = KSquirrel::app()->filtersExtensions()->begin();

    for(;it_name != nEND;++it_name,++it_ext)
    {
        if(itemafter)
            item = new TQListViewItem(listFilters, itemafter, *it_name, *it_ext);
        else
            item = new TQListViewItem(listFilters, *it_name, *it_ext);

        itemafter = item;

        item->setRenameEnabled(0, true);
        item->setRenameEnabled(1, true);
        item->setMultiLinesEnabled(false);
    
        listFilters->insertItem(item);
    }

    pushFilterUp->setPixmap(SQ_IconLoader::instance()->loadIcon("move_task_up", TDEIcon::Desktop, TDEIcon::SizeSmall));
    pushFilterDown->setPixmap(SQ_IconLoader::instance()->loadIcon("move_task_down", TDEIcon::Desktop, TDEIcon::SizeSmall));
    pushNew->setPixmap(SQ_IconLoader::instance()->loadIcon("document-new", TDEIcon::Desktop, TDEIcon::SizeSmall));
    pushDelete->setPixmap(SQ_IconLoader::instance()->loadIcon("edit-delete", TDEIcon::Desktop, TDEIcon::SizeSmall));
    pushClearAll->setPixmap(SQ_IconLoader::instance()->loadIcon("edittrash", TDEIcon::Desktop, TDEIcon::SizeSmall));

    listFilters->setCurrentItem(listFilters->firstChild());
    listFilters->clearSelection();
    listFilters->setSelected(listFilters->currentItem(), true);

    SQ_Config::instance()->setGroup("Filters");
 
    checkBoth->setChecked(SQ_Config::instance()->readBoolEntry("menuitem both", true));
}

void SQ_Filters::slotNewFilter()
{
    TQListViewItem *itemafter = listFilters->lastItem(), *item;

    if(itemafter)
        item = new TQListViewItem(listFilters, itemafter, i18n("Name"), "*.");
    else
        item = new TQListViewItem(listFilters,  i18n("Name"), "*.");

    item->setRenameEnabled(0, true);
    item->setRenameEnabled(1, true);
    item->setMultiLinesEnabled(false);
    listFilters->insertItem(item);
    item->startRename(0);

}

void SQ_Filters::slotFilterClear()
{
    TQListViewItem *item = listFilters->currentItem();

    if(!item) return;
    
    listFilters->takeItem(item);

    item = listFilters->currentItem();
    
    if(item)
        listFilters->setSelected(item, true);
}

void SQ_Filters::slotFilterUp()
{
    TQListViewItem *item = listFilters->currentItem();
    
    if(!item) return;
 
    TQListViewItem *itemafter = item->itemAbove();
    
    if(!itemafter) return;
 
    itemafter->moveItem(item);
}

void SQ_Filters::slotFilterDown()
{
    TQListViewItem *item = listFilters->currentItem();
    
    if(!item) return;
 
    TQListViewItem *itemafter = item->itemBelow();
    
    if(!itemafter) return;
 
    item->moveItem(itemafter);

}

int SQ_Filters::start()
{
    int result = exec();
    
    if(result == TQDialog::Accepted)
    {
        TQListViewItem *cur = listFilters->firstChild();

        KSquirrel::app()->filtersNames()->clear();
        KSquirrel::app()->filtersExtensions()->clear();

        for(;cur;cur = cur->itemBelow())
        {
            KSquirrel::app()->filtersNames()->append(cur->text(0));
            KSquirrel::app()->filtersExtensions()->append(cur->text(1));
        }

        SQ_Config::instance()->setGroup("Filters");
        SQ_Config::instance()->writeEntry("menuitem both", checkBoth->isChecked());
    }
    
    return result;
}


void SQ_Filters::slotFilterRenameRequest( TQListViewItem *item, const TQPoint &, int pos )
{
    if(item)
        item->startRename(((pos>=0)?pos:0));
}
