/***************************************************************************
                          commands_edit  -  description
                             -------------------
    begin                : Wed Nov 26 2003
    copyright            : (C) 2003 by The KXMLEditor Team
    email                : a_charytoniuk@user.sourceforge.net
 ***************************************************************************/

 /***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef COMMANDS_EDIT_H
#define COMMANDS_EDIT_H

#include "kxecommand.h"

#include <tdelocale.h>

#include <tqobjectlist.h>

/**
@file
@author The KXMLEditor Team
*/

/**
	@brief Command for removing any kind of nodes.
*/
class KXEDeleteNodeCommand : public KXECommand
{
	public:
		/** @brief Constructor */
		KXEDeleteNodeCommand(KXEDocument*, TQDomNode &);
		/** @brief Destructor */
		~KXEDeleteNodeCommand();
		/** @brief Performs node removal.*/
		virtual void execute();
		/** @brief Node removal rollback.*/
		virtual void unexecute();
		virtual TQString name() const { return i18n("Delete node"); }
	protected:
		/** @short Stores infromation about parent node of the node to be deleted. */
		TQDomNode m_domParentNode;
		/** @short Stores infromation the node to be deleted. */
		TQDomNode m_domNode;
		/** @short Stores infromation about sibling node of the node to be deleted. */
		TQDomNode m_afterNode;
};
/**
	@short Command for removing element attributes.
*/
class KXEDeleteAttrCommand : public KXECommand
{
	public:
		/** @brief Constructor */
		KXEDeleteAttrCommand(KXEDocument*, TQDomElement &, TQDomAttr &);
		/** @brief Destructor */
		~KXEDeleteAttrCommand();
                /** @brief Preforms attributte removal. */
		virtual void execute();
                /** @brief Attributte removal rollback. */
		virtual void unexecute();
		virtual TQString name() const { return i18n("Delete attribute"); }
	protected:
		/** @brief Stores attribute owner. */
		TQDomElement m_domOwnerElement;
		/** @brief Attribute about to be removed. */
		TQDomAttr m_domAttr;
};

/**
	@short Command for removing all element attributes.
*/
class KXEDeleteAllAttribCommand : public KXECommand
{
	public:
		/** @brief Constructor */
		KXEDeleteAllAttribCommand(KXEDocument*, TQDomElement &);
		/** @brief Destructor */
		~KXEDeleteAllAttribCommand();
		virtual void execute();
		virtual void unexecute();
		virtual TQString name() const { return i18n("Delete all attributes"); }
	protected:
		TQDomElement m_domOwnerElement;
		TQPtrList<TQDomAttr> m_listRemovedAttributes;
};

/**
	@short Command for cutting element to clipboard.
*/
class KXECutCommand : public KXEDeleteNodeCommand
{
	public:
		/** @brief Constructor */
		KXECutCommand(KXEDocument*, TQDomNode &);
		/** @brief Destructor */
		~KXECutCommand();
		virtual TQString name() const { return i18n("Cut node"); }
};

/**
	@short Command for pasting to document from clipboard.
*/
class KXEPasteToDocumentCommand : public KXECommand
{
	public:
		/** @brief Constructor */
		KXEPasteToDocumentCommand(KXEDocument*, TQDomDocument *, TQDomElement &);
		/** @brief Destructor */
		~KXEPasteToDocumentCommand();
		virtual void execute();
		virtual void unexecute();
		virtual TQString name() const { return i18n("Paste node to document"); }
	protected:
		TQDomDocument * m_pDomTargetDoc;
		TQDomElement m_domSourceElement;
};

/**
	@short Command for pasting element from clipboard.
*/
class KXEPasteToElementCommand : public KXECommand
{
	public:
		/** @brief Constructor */
		KXEPasteToElementCommand(KXEDocument*, TQDomElement &, TQDomNode &);
		/** @brief Destructor */
		~KXEPasteToElementCommand();
		virtual void execute();
		virtual void unexecute();
		virtual TQString name() const { return i18n("Paste node to element"); }
	protected:
		TQDomElement m_domTargetElement;
		TQDomNode m_domSourceNode;
};

class KXEPasteToProcInstrCommand : public KXECommand
{
	public:
		/** @brief Constructor */
		KXEPasteToProcInstrCommand(KXEDocument*, TQDomProcessingInstruction &, TQDomProcessingInstruction &);
		/** @brief Destructor */
		~KXEPasteToProcInstrCommand();
		virtual void execute();
		virtual void unexecute();
		virtual TQString name() const { return i18n("Paste node to proc. instruction"); }
	protected:
		TQDomProcessingInstruction m_domTargetProcInstr;
		TQString m_strNewData;
		TQString m_strOldData;
};

class KXEPasteToCharDataCommand : public KXECommand
{
	public:
		/** @brief Constructor */
		KXEPasteToCharDataCommand(KXEDocument*, TQDomCharacterData &, TQDomCharacterData &);
		/** @brief Destructor */
		~KXEPasteToCharDataCommand();
		virtual void execute();
		virtual void unexecute();
		virtual TQString name() const { return i18n("Paste node to char. data"); }
	protected:
		TQDomCharacterData m_domTargetCharData;
		TQString m_strNewData;
		TQString m_strOldData;
};

/**
	@short Command for Drag & Drop.
*/
class KXEDragDropMoveCommand : public KXECommand
{
	public:
		/** @brief Constructor */
		KXEDragDropMoveCommand(KXEDocument*, TQDomElement &, TQDomNode &);
		/** @brief Destructor */
		~KXEDragDropMoveCommand();
		virtual void execute();
		virtual void unexecute();
		virtual TQString name() const { return i18n("Drag&&drop node"); }
	protected:
		TQDomElement m_domTargetElement;
		TQDomNode m_domSourceNode;
		TQDomNode m_domPreviousParentNode;
};

/**
	@short Command for moving selected node up.
*/
class KXEUpCommand : public KXECommand
{
	public:
		/** @brief Constructor */
		KXEUpCommand(KXEDocument*, TQDomNode &);
		/** @brief Destructor */
		~KXEUpCommand();
		virtual void execute();
		virtual void unexecute();
		virtual TQString name() const { return i18n("Move node up"); }
	protected:
		TQDomNode m_domParentNode;
		TQDomNode m_domNode;
};

/**
	@short Command for moving selected node down.
*/
class KXEDownCommand : public KXECommand
{
	public:
		/** @brief Constructor */
		KXEDownCommand(KXEDocument*, TQDomNode &);
		/** @brief Destructor */
		~KXEDownCommand();
		virtual void execute();
		virtual void unexecute();
		virtual TQString name() const { return i18n("Move node down"); }
	protected:
		TQDomNode m_domParentNode;
		TQDomNode m_domNode;
};

class KXEEditCharDataCommand : public KXECommand
{
	public:
		/** @brief Constructor */
		KXEEditCharDataCommand(KXEDocument*, TQDomCharacterData &, const TQString);
		/** @brief Destructor */
		~KXEEditCharDataCommand();
		virtual void execute();
		virtual void unexecute();
		virtual TQString name() const { return i18n("Editing character data"); }
	protected:
		TQDomCharacterData m_domCharacterData;
		TQString m_strNewContents;
		TQString m_strOldContents;
};

/**
	@short Command for editing selected processing instruction.
*/
class KXEEditProcInstrCommand : public KXECommand
{
	public:
		/** @brief Constructor */
		KXEEditProcInstrCommand(KXEDocument*, TQDomProcessingInstruction &, const TQString);
		/** @brief Destructor */
		~KXEEditProcInstrCommand();
		virtual void execute();
		virtual void unexecute();
		virtual TQString name() const { return i18n("Editing proc. instruction"); }
	protected:
		TQDomProcessingInstruction m_domProcInstr;
		TQString m_strNewData;
		TQString m_strOldData;
};

/**
	@short Command for editing selected XML element.
*/
class KXEEditElementCommand : public KXECommand
{
	public:
		/** @brief Constructor */
		KXEEditElementCommand(KXEDocument*, TQDomElement &, const TQString, const TQString);
		/** @brief Destructor */
		~KXEEditElementCommand();
		virtual void execute();
		virtual void unexecute();
		virtual TQString name() const { return i18n("Editing element"); }
	protected:
		TQDomElement m_domElement;
		TQString m_strNewPrefix;
		TQString m_strNewName;
		TQString m_strOldPrefix;
		TQString m_strOldName;
};

/**
	@short Command for editing element attribute value.
*/
class KXEEditAttrValueCommand : public KXECommand
{
	public:
		/** @brief Constructor */
		KXEEditAttrValueCommand(KXEDocument*, const TQDomAttr &, const TQString);
		/** @brief Destructor */
		~KXEEditAttrValueCommand();
		virtual void execute();
		virtual void unexecute();
		virtual TQString name() const { return i18n("Edit attribute value"); }
	protected:
		TQDomAttr m_domAttr;
		TQString m_strNewValue;
		TQString m_strOldValue;
};

/**
	@short Command for editing element attribute names.
*/
class KXEEditAttrNameCommand : public KXECommand
{
	public:
		/** @brief Constructor */
		KXEEditAttrNameCommand(KXEDocument*, const TQDomAttr &, const TQString);
		/** @brief Destructor */
		~KXEEditAttrNameCommand();
		virtual void execute();
		virtual void unexecute();
		virtual TQString name() const { return i18n("Edit attribute name"); }
	protected:
		TQDomElement m_domOwnerElement;
		TQString m_strNewName;
		TQString m_strOldName;
		TQString m_strValue;
		TQString m_strNamespaceURI;
};

/**
	@short Command for editing XML element as text.
*/
class KXEEditRawXmlCommand : public KXECommand
{
	public:
		/** @brief Constructor */
		KXEEditRawXmlCommand(KXEDocument*, TQDomElement &, TQDomElement &);
		/** @brief Destructor */
		~KXEEditRawXmlCommand();
		virtual void execute();
		virtual void unexecute();
		virtual TQString name() const { return i18n("Editing raw XML"); }
	protected:
		TQDomElement m_domOldElement;
		TQDomNode m_domParentNode;
		TQDomElement m_domNewElement;
		TQDomNode m_afterNode;
};

#endif
