/***************************************************************************
                          kxe_treeviewitem.h  -  description
                             -------------------
    begin                : Wed Nov 21 2001
    copyright            : (C) 2001, 2002, 2003 by The KXMLEditor Team
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KXE_TREEVIEWITEM_H
#define KXE_TREEVIEWITEM_H

#include <tqlistview.h>
#include <tqpixmap.h>
#include <tqdom.h>

class TDEListView;

/**
 * This is a tree item, which represents one XML node (see @ref TQDomNode and its childclasses).
 * @short tree item
 * @author The KXMLEditor Team
 */
class KXE_TreeViewItem : public TQListViewItem
{
	public:

		KXE_TreeViewItem( const TQDomNode & xmlNode, TDEListView * pParent,  TQListViewItem* pAfter=NULL);
		KXE_TreeViewItem( const TQDomNode & xmlNode, TQListViewItem * pParent );
		KXE_TreeViewItem( const TQDomNode & xmlNode, TQListViewItem * pParent, TQListViewItem * pAfter );
    ~KXE_TreeViewItem();
    
		/** 
		 * (Re)sets the texts of the columns of this listitem
		 * depending on type of corresponding XML node and
		 * element display mode, which is stored in the configuration
		 * (@ref KXETreeViewSettings::elemDisplMode).
		 */
		void setTexts();

		/** Returns the corresponding XML node, e.g. the XML node represented by this tree item. */
		TQDomNode * xmlNode() { return & m_xmlNode; }

    /** Returns true, if this tree item is bookmarked (false otherwise). */
		bool isBookmarked() const { return m_bBookmarked; }

    /** Changes this items bookmark status (see @ref KXE_TreeViewItem::m_bBookmarked) and returns the new one. */
		bool toggleBookmark();

		/** Returns this items last child or a null pointer if there are no childs at all. */
		KXE_TreeViewItem * lastChild() const;

		/** Sets this items previous sibling. */
		void setPrevSibling( KXE_TreeViewItem * const pPrevSibling ) { m_pPrevSibling = pPrevSibling; }

    /** Returns this items previous sibling. */
		KXE_TreeViewItem * prevSibling() const { return m_pPrevSibling; }

		/**
		* Does the same like @ref TQListViewItem::itemAbove but the parent items doesn't need to be open.
		* Returns this items previous siblings last grand child, if there is one.
		* Otherwise it returns this items previous sibling or,
		* if there are no sibling above, it returns this items parent or
		* a null pointer (if there is no parent).
		*/
		KXE_TreeViewItem * prevItem();

    /**
		* Does the same like @ref TQListViewItem::itemBelow but the parent items doesn't need to be open.
		* Returns a pointer to the next item of this or a null pointer if this is the last item.
		* This will be it's first child,
		* if there are no childs, it will be the next sibling
		* and if there are no siblings below, it will be this' parents next sibling ...
		*/
		KXE_TreeViewItem * nextItem();

		/** Expands this items child tree up to the given level or expands the entire child tree, if iLevel == -1.  */
		void expandSubTree( int iLevel = -1 );

    /** Collapses this items child tree to the given level or collapses the entire child tree, if iLevel == 0.  */
		void collapseSubTree( int iLevel = 0 );

		/** Test, if item in parameter is my direct or indirect child item */
  bool isMyChildren(const KXE_TreeViewItem *);

		/** 
		 * If the child items aren't created (initialized) yet
		 * (i.e. if m_bChildsCreated is false), it is done now.
		 */
		void ensureChildItemsCreated();
		/** 
		 * If the grandchilds (child items of this item's childs) aren't created (initialized)
		 * yet (i.e. if m_bGrandChildsCreated is false), it is done now.
		 */
		void ensureGrandChildItemsCreated();

		/**
		 * Starts in-place renaming, if the given column is set to be in-place 
		 * renameable in the item's view
		 */
		virtual void startRename( int iCol );

protected:

		TQDomNode m_xmlNode;
		KXE_TreeViewItem * m_pPrevSibling;
		bool m_bBookmarked;
		bool m_bChildsCreated;
		bool m_bGrandChildsCreated;

private:

		void init();
		void initChilds();
};

#endif
