/***************************************************************************
                          kxeelementdialog.h  -  description
                          ------------------
    begin                : Mit Apr 17 2002
    copyright            : (C) 2002, 2003 by The KXMLEditor Team
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KXEELEMENTDIALOG_H
#define KXEELEMENTDIALOG_H

#include "kxeelementdialogbase.h"

class KXEElementDialog : public KXEElementDialogBase
{
		TQ_OBJECT

	public:
		KXEElementDialog( TQWidget * pParent = 0, const char * pszName = 0, bool fModal = true, WFlags fl = 0 );

	public:

    const TQString nsURI() const { return m_strNsURI; }
    const TQString prefix() const { return m_strPrefix; }
    const TQString name() const { return m_strName; }
    const bool atTop() const { return m_bAtTop; }

    void setNsURI(const TQString strNsURI) { m_strNsURI = strNsURI; }
    void setPrefix(const TQString strPrefix) { m_strPrefix = strPrefix; }
    void setName(const TQString strName)  { m_strName = strName; }
  
		/**
		 * To be used for creating a new XML element 
		 *
		 * @return see @ref TQDialog::exec
		 */
		int exec( bool, bool, bool );

    // check element name
    static TQString checkName(const TQString);
		
	protected:
    /**
		 * Clears the dialogs widgets (removes their content).
		 */
     
		void clearDialog();

    /**
		 * Fills the dialogs widgets with the data members.
		 */
		void fillDialog( bool );

		/**
		 * Don't use this function directly, it's for internal use only.
		 * Use one of the other @ref DlgXMLElement::exec functions instead.
		 */
		int exec();
		/**
		 * Called, when the namespace URI in the edit line @ref DlgXMLElementBase::m_pEditNsURI
		 * is changed.
		 * Disables the prefix edit line (@ref DlgXMLElementBase::m_pEditPrefix),
		 * if the given string is empty.
		 */
  

 protected slots:
		void slotNsURIChanged( const TQString & szNewNsURI );
		/**
		 * Called, when the name in the edit line @ref DlgXMLElementBase::m_pEditName
		 * is changed.
		 * Disables the OK button, if the given string is empty.
		 */
		void slotNameChanged( const TQString & szNewName );

protected:
    TQString m_strNsURI;
    TQString m_strPrefix;
    TQString m_strName;
    bool m_bAtTop;
};

#endif
