/***************************************************************************
 *   Copyright (C) 2006 by Marco Gulino   *
 *   marco@kmobiletools.org   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "mplayer-thumbnailer-config.h"
#include <tqvbox.h>
#include <klineedit.h>
#include <kpushbutton.h>
#include <tqlabel.h>
#include <tdelocale.h>
#include <tdestandarddirs.h>
#include <kdebug.h>
#include <tqtimer.h>
#include <keditlistbox.h>

MPlayerThumbnailerConfig::MPlayerThumbnailerConfig(TQWidget *parent, const char *name, MPlayerThumbnailerCfg *config, DialogType dialogType, int dialogButtons, ButtonCode defaultButton, bool modal)
    : TDEConfigDialog(parent, name, config, dialogType, dialogButtons, defaultButton, modal)
{
    TQVBox *vbox=new TQVBox(0);
    vbox->setSpacing( 5);
    new TQLabel(i18n("Enter here the path for mplayer executable file."), vbox);
    kcfg_mplayerbin=new KLineEdit( vbox, "kcfg_mplayerbin");
    new TQLabel(i18n("Custom arguments for mplayer."), vbox);
    new KLineEdit( vbox, "kcfg_customargs");
    new KEditListBox( i18n("Blacklisted File Extensions"),
            vbox, "kcfg_noextensions", true, KEditListBox::Add | KEditListBox::Remove);
    addPage( vbox, i18n("General"), "mplayer" );
    kdDebug() << "config->mplayerbin().isNull()::" << config->mplayerbin().length() << endl;
    if(!config->mplayerbin().length() )
        TQTimer::singleShot( 100, this, TQ_SLOT(autoFindPath()));
}

MPlayerThumbnailerConfig::~MPlayerThumbnailerConfig()
{
}

/*!
    \fn MPlayerThumbnailerConfig::autoFindPath()
 */
void MPlayerThumbnailerConfig::autoFindPath()
{
    TQString playerPath=TDEStandardDirs::findExe("mplayer-bin");
    if(playerPath.isNull() ) playerPath=TDEStandardDirs::findExe("mplayer");
    kdDebug() << "Trying to set player path to " << playerPath << endl;
    kcfg_mplayerbin->setText( playerPath );
}

#include "mplayer-thumbnailer-config.moc"
