/***************************************************************************
 *   Copyright (C) 2005-2006 Nicolas Hadacek <hadacek@kde.org>             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef PFILE_H
#define PFILE_H

#include <tqtextstream.h>
#include "purl.h"

namespace PURL
{
//-----------------------------------------------------------------------------
class FileBase
{
public:
  FileBase(Log::Generic &log, const TQString &extension);
  ~FileBase();
  TQFile *qfile();
  const TQFile *qfile() const;
  TQTextStream &stream();
  TQString readText() { return stream().read(); }
  TQString readLine() { return stream().readLine(); }
  TQStringList readLines();
  TQByteArray readAll();
  void appendText(const TQString &text) { stream() << text; }
  void flush();
  bool hasError() const;
  TQString errorString() const;

protected:
  KTempFile    *_tmp;
  TQFile        *_file;
  TQTextStream  *_stream;
  TQString       _error, _extension;
  Log::Generic &_log;

private: // disable copy constructor and operator =
  FileBase(const FileBase &base);
  FileBase &operator =(const FileBase &base);
};

//-----------------------------------------------------------------------------
class File : public FileBase
{
public:
  File(const Url &url, Log::Generic &log);
  ~File() { close(); }
  void setUrl(const Url &url); // close file too
  Url url() const { return _url; }
  bool openForWrite();
  bool openForRead();
  bool close();
  bool remove();

private:
  Url _url;
};

} // namespace

#endif
