"""
Copyright 2003 Jim Bublitz

Terms and Conditions

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
COPYRIGHT HOLDER BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

Except as contained in this notice, the name of the copyright holder shall
not be used in advertising or otherwise to promote the sale, use or other
dealings in this Software without prior written authorization from the
copyright holder.
"""

import sys

from PyTQt.tqt import TQLabel
from tdecore import TDEAboutData, TDEApplication, TDECmdLineArgs, TDEIcon, TDEIconLoader
from tdeui import TDEMainWindow, KSystemTray

class MainWin (TDEMainWindow):
    def __init__ (self, *args):
        TDEMainWindow.__init__(self, *args)

#-------------------- main ------------------------------------------------

description = b"A basic application template"
version     = b"1.0"
aboutData   = TDEAboutData (b"MyApp", b"MyApp",\
    version, description, TDEAboutData.License_GPL,\
    b"(C) 2003 whoever the author is")

aboutData.addAuthor (b"author1", b"whatever they did", b"email@somedomain")
aboutData.addAuthor (b"author2", b"they did something else", b"another@email.address")

TDECmdLineArgs.init (sys.argv, aboutData)

TDECmdLineArgs.addCmdLineOptions ([(b"+files", b"File to open")])

app = TDEApplication ()
mainWindow = MainWin(None, "main window")
icons = TDEIconLoader ()

systray = KSystemTray (mainWindow)
systray.setPixmap (icons.loadIcon("process-stop", TDEIcon.Desktop))
systray.show ()

app.exec_loop()


