"""
Copyright 2003 Jim Bublitz

Terms and Conditions

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
COPYRIGHT HOLDER BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

Except as contained in this notice, the name of the copyright holder shall
not be used in advertising or otherwise to promote the sale, use or other
dealings in this Software without prior written authorization from the
copyright holder.
"""

import sys

from PyTQt.tqt import TQWidget, TQ_SIGNAL
from tdecore import TDEApplication, TDEIcon, TDEIconLoader
from tdeui import  KSystemTray

"""
Typically an application's "main window" will be a TDEMainWindow or
a subclass of TDEMainWindow (TDEMainWindow provides simple mechanisms
for constructing mens, toolbars, statusbars, etc). The problem with
using TDEMainWindow in a System Tray application is that when
TDEMainWindow is closed, it also shuts down TDEApplication and the
program terminates.

One way around that (not necessarily the best way - see systray1.py)
is to make the "main window" a TQWidget or other TQWidget subclass
that's not TDEMainWindow.
"""

class MainWin (TQWidget):
    def __init__ (self, *args):
        apply (TQWidget.__init__, (self,) + args)

#-------------------- main ------------------------------------------------

# This slot receives the "quitSelected ()" signal that's emitted
# when the user right clicks the icon in the system tray and
# selects "Quit" from the popup menu
def slotQuitSelected ():
    TDEApplication.tdeApplication ().quit ()

# The usual stuff
appName = "template"
app = TDEApplication (sys.argv, appName)
mainWindow = MainWin (None, "main window")

# System tray apps need an icon
icons = TDEIconLoader ()

# The KSystemTray widget shows or hides it's parent widget
# when clicked, so parent needs to be the main window
systray = KSystemTray (mainWindow)

systray.setPixmap (icons.loadIcon("process-stop", TDEIcon.Desktop))
systray.connect (systray, TQ_SIGNAL ("quitSelected ()"), slotQuitSelected)
systray.show ()

# Comment this out if you don't want the main window to show
# immediately when the application loads
mainWindow.show()
app.exec_loop()


