/**********************************************************************
**   Copyright (C) 2000 Trolltech AS.  All rights reserved.
**
**   proparser.cpp
**
**   This file is part of TQt Linguist.
**
**   See the file LICENSE included in the distribution for the usage
**   and distribution terms.
**
**   The file is provided AS IS with NO WARRANTY OF ANY KIND,
**   INCLUDING THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR
**   A PARTICULAR PURPOSE.
**
**********************************************************************/

#include <tqregexp.h>
#include <tqstringlist.h>

#include "proparser.h"

TQMap<TQString, TQString> proFileTagMap( const TQString& text )
{
    TQString t = text;

    /*
      Strip comments, merge lines ending with backslash, add
      spaces around '=' and '+=', replace '\n' with ';', and
      simplify white spaces.
    */
    t.replace( TQRegExp(TQString("#[^\n]$")), TQString(" ") );
    t.replace( TQRegExp(TQString("\\\\\\s*\n")), TQString(" ") );
    t.replace( TQRegExp(TQString("=")), TQString(" = ") );
    t.replace( TQRegExp(TQString("\\+ =")), TQString(" += ") );
    t.replace( TQRegExp(TQString("\n")), TQString(";") );
    t = t.simplifyWhiteSpace();

    TQMap<TQString, TQString> tagMap;

    TQStringList lines = TQStringList::split( TQChar(';'), t );
    TQStringList::Iterator line;
    for ( line = lines.begin(); line != lines.end(); ++line ) {
	TQStringList toks = TQStringList::split( TQChar(' '), *line );

        if ( toks.count() >= 3 && 
             (toks[1] == TQString("=") || toks[1] == TQString("+=")) ) {
            TQString tag = toks.first();
	    int k = tag.findRev( TQChar(':') ); // as in 'unix:'
	    if ( k != -1 )
		tag = tag.mid( k + 1 );
            toks.remove( toks.begin() );

            TQString action = toks.first();
            toks.remove( toks.begin() );

            if ( tagMap.contains(tag) ) {
                if ( action == TQString("=") )
                    tagMap.replace( tag, toks.join(TQChar(' ')) );
                else
                    tagMap[tag] += TQChar( ' ' ) + toks.join( TQChar(' ') );
            } else {
                tagMap[tag] = toks.join( TQChar(' ') );
	    }
        }
    }

    TQRegExp var( "\\$\\$[a-zA-Z0-9_]+" );
    TQMap<TQString, TQString>::Iterator it;
    for ( it = tagMap.begin(); it != tagMap.end(); ++it ) {
        int i = 0;

        while ( (i = var.search(it.data(), i)) != -1 ) {
	    int len = var.matchedLength();
            (*it).replace( i, len, tagMap[(*it).mid(i + 2, len - 2)] );
	}
    }
    return tagMap;
}
