/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.

    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>

    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef _RG_FILELOCATEDIALOG_H_
#define _RG_FILELOCATEDIALOG_H_

#include <kdialogbase.h>
#include <tqstring.h>


class TQWidget;


namespace Rosegarden
{



class FileLocateDialog : public KDialogBase
{
    TQ_OBJECT
  

public:
    FileLocateDialog(TQWidget *parent,
                     const TQString &file,
                     const TQString &path);

    TQString getDirectory() { return m_path; }
    TQString getFilename() { return m_file; }

protected:
    virtual void slotUser1();
    virtual void slotUser2();
    virtual void slotUser3();

    TQString m_file;
    TQString m_path;

};
  

}

#endif
