/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.
 
    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>
 
    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.
 
    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.
 
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/


#include "QuantizeDialog.h"

#include <tdelocale.h>
#include "base/Quantizer.h"
#include "gui/widgets/QuantizeParameters.h"
#include <kdialogbase.h>
#include <tqvbox.h>
#include <tqwidget.h>


namespace Rosegarden
{

QuantizeDialog::QuantizeDialog(TQWidget *parent, bool inNotation) :
        KDialogBase(parent, 0, true, i18n("Quantize"), Ok | Cancel | Details | Help)
{
    setHelp("quantization");

    TQVBox *vbox = makeVBoxMainWidget();

    m_quantizeFrame =
        new QuantizeParameters
        (vbox, inNotation ? QuantizeParameters::Notation :
         QuantizeParameters::Grid,
         true, false, 0);

    setButtonText(Details, i18n("Advanced"));
    setDetailsWidget(m_quantizeFrame->getAdvancedWidget());
    m_quantizeFrame->getAdvancedWidget()->hide();

    m_quantizeFrame->adjustSize();
    vbox->adjustSize();
    adjustSize();
}

Quantizer *
QuantizeDialog::getQuantizer() const
{
    return m_quantizeFrame->getQuantizer();
}

}
#include "QuantizeDialog.moc"
