/***************************************************************************
    smb4kdefs.h  -  Definitions for Smb4K
                             -------------------
    begin                : Mo Mär 15 2004
    copyright            : (C) 2004 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/


#ifndef SMB4KDEFS_H
#define SMB4KDEFS_H


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

//
// Run states
//

#define SCANNER_INIT                          0
#define SCANNER_OPENING_WORKGROUP             1
#define SCANNER_OPENING_HOST                  2
#define SCANNER_RETRIEVING_INFO               3
#define SCANNER_SEARCHING                     4
#define SCANNER_RETRYING_OPENING_HOST         5
#define SCANNER_STOP                          6
#define MOUNTER_MOUNTING                      7
#define MOUNTER_UNMOUNTING                    8
#define MOUNTER_STOP                          9
#define PRINT_START                          10
#define PRINT_STOP                           11
#define SYNCHRONIZER_START                   12
#define SYNCHRONIZER_STOP                    13
#define PREVIEWER_START                      14
#define PREVIEWER_STOP                       15
#define CORE_STOP                            16

//
// Error codes:
//

// (1) Network related errors.
#define ERROR_GETTING_BROWSELIST            100
#define ERROR_GETTING_MEMBERS               101
#define ERROR_GETTING_SHARES                102
#define ERROR_GETTING_PREVIEW               103
#define ERROR_NET_COMMAND                   104
#define ERROR_IP_CANNOT_BE_USED             105

// (2) Errors involving mounting, unmounting
// and importing shares.
#define ERROR_MOUNTING_SHARE                106
#define ERROR_UNMOUNTING_SHARE              107
#define ERROR_UNMOUNTING_NOT_ALLOWED        108
#define ERROR_MOUNTPOINT_EMPTY              109
#define ERROR_IMPORTING_SHARES              110

// (3) Errors that are connected to printing
#define ERROR_PRINTING                      111

// (4) Errors that are connected to
// synchronization
#define ERROR_SYNCHRONIZING                 112

// (5) Errors that occur when handling
// bookmarks
#define ERROR_BOOKMARK_PRINTER              113

// (6) Errors that occur when handling
// authentication data
#define ERROR_OPENING_WALLET_FAILED         114

// (7) Errors that occur when handling files
// and directories.
#define ERROR_FILE_NOT_FOUND                115
#define ERROR_OPENING_FILE		              116
#define ERROR_READING_FILE                  117
#define ERROR_WRITING_FILE                  118
#define ERROR_CLOSING_FILE                  119
#define ERROR_GETTING_PERMISSIONS           120
#define ERROR_DIRECTORY_NOT_FOUND           121
#define ERROR_CREATING_TEMP_DIR             122
#define ERROR_CREATING_TEMP_FILE            123
#define ERROR_FILE_IS_IRREGULAR             124
#define ERROR_MKDIR_FAILED                  125

// (8) Errors that occur when handling programs
#define ERROR_MISSING_PROGRAMS              126
#define ERROR_COMMAND_NOT_FOUND             127

// (9) Other errors
#define ERROR_UNKNOWN                       128
#define ERROR_GETTING_HOSTNAME              129
#define ERROR_LOCKED                        130
#define ERROR_FEATURE_NOT_ENABLED           131
#define ERROR_GETTING_GIDS                  132

//
// Warning codes:
//

/* None defined yet. use 200 ff. for that */

//
// Information codes:
//

#define INFO_MIMETYPE_NOT_SUPPORTED         300
#define INFO_DISABLE_SUID_FEATURE           301
#define INFO_BOOKMARK_LABEL_IN_USE          302

//
// Event types
//

#define EVENT_LOAD_SETTINGS              100000
#define EVENT_SET_FOCUS                  100001
#define EVENT_SCAN_NETWORK               100002

//
// Other definitions
//

#define TIMER_INTERVAL                       25
#define THREAD_WAITING_TIME                 100
#define TEMPPATHLEN                          18

#endif
