/***************************************************************************
    smb4ksearchdialog_part  -  This Part encapsulates the search dialog
    of Smb4K.
                             -------------------
    begin                : Fr Jun 1 2007
    copyright            : (C) 2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KSEARCHDIALOGPART_H
#define SMB4KSEARCHDIALOGPART_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// TQt includes
#include <tqlistview.h>

// KDE includes
#include <tdeparts/part.h>
#include <tdeparts/factory.h>

// forward declarations
class Smb4KSearchDialog;
class Smb4KHostItem;


/**
 * This is one of the parts of Smb4K. It contains the search dialog.
 *
 * @author Alexander Reinholdt <dustpuppy@users.berlios.de>
 */

class Smb4KSearchDialogPart : public KParts::Part
{
  TQ_OBJECT
  

  public:
    /**
     * The constructor.
     *
     * @param parentWidget        The parent widget
     *
     * @param widgetName          The name the widget should have
     *
     * @param parent              The parent object
     *
     * @param name                The name this object should have
     */
    Smb4KSearchDialogPart( TQWidget *parentWidget = 0, const char *widgetName = 0,
                           TQObject *parent = 0, const char *name = 0 );

    /**
     * The destructor.
     */
    virtual ~Smb4KSearchDialogPart();

  protected:
    /**
     * Reimplemented from KParts::Part.
     */
    void customEvent( TQCustomEvent *e );

  protected slots:
    /**
     * This slot is connected to the Smb4KSearchDialog::buttonPressed()
     * signal. It initializes the search process, etc.
     *
     * @param button_id           The button id according to
     *                            Smb4KSearchDialog::ToolBarWidgets.
     */
    void slotButtonPressed( int button_id );

    /**
     * This slot retrieves the search result and puts it into the search
     * dialog.
     *
     * @param item                A Smb4KHostItem object
     */
    void slotReceivedSearchResult( Smb4KHostItem *item );

    /**
     * This slot is connected to the Smb4KScanner::hostListChanged() signal
     * and checks whether the host is already known, i.e. it is in the browser,
     * or if it is "new". If it is already known, this slot will change the icon
     * of the host item from the default one to one with a tick layed over.
     */
    void slotCheckItemIsKnown();

    /**
     * This slot is invoked, when a user double clicks an item. It adds the item
     * to the list of known hosts (if necessary).
     *
     * @param item                The item that has been double clicked.
     */
    void slotItemDoubleClicked( TQListViewItem *item );

  private:
    /**
     * This is the actual search dialog widget.
     */
    Smb4KSearchDialog *m_widget;

    /**
     * Work around insertion "problems" of the search dialog items.
     */
    int m_serial_number;
};


class TDEInstance;
class TDEAboutData;

class Smb4KSearchDialogPartFactory : public KParts::Factory
{
  TQ_OBJECT
  

  public:
    /**
     * The constructor
     */
    Smb4KSearchDialogPartFactory();

    /**
     * The destructor
     */
    virtual ~Smb4KSearchDialogPartFactory();

    /**
     * Reimplemented from KParts::Factory
     */
    virtual KParts::Part *createPartObject( TQWidget *parentWidget, const char *widgetName,
                                            TQObject *parent, const char *name,
                                            const char *classname, const TQStringList &args );

    /**
     * The instance
     */
    static TDEInstance *instance();

  private:
    /**
     * The factory's instance.
     */
    static TDEInstance *m_instance;

    /**
     * The factory's TDEAboutData object
     */
    static TDEAboutData *m_about;
};

#endif
