/*
** Copyright (C) 1999,2000 Toivo Pedaste <toivo@ucs.uwa.edu.au>
**
*/

/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program in a file called COPYING; if not, write to
** the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
** MA 02110-1301, USA.
*/

/*
** Bug reports and questions can be sent to kde-devel@kde.org
*/


#ifndef PKG_IFACE_H
#define PKG_IFACE_H

#include "../config.h"
#include <tqptrlist.h>
#include <tqstring.h>
#include <tqstringlist.h>

#include <tdeglobal.h>
#include <tdestandarddirs.h>

#include "packageInfo.h"
#include "managementWidget.h"

class packageInfo;
class pkgOptions;
class Locations;
class LcacheObj;
class cacheObj;
class TDEAccel;
class TDEActionCollection;
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

//  flags to install and uninstall
class param
{
public:
  param(const TQString &nameP, bool initP,  bool invertP, const TQString &flagP);
  param(const TQString &nameP, bool initP,  bool invertP, const TQString &flagP, const TQString &flagAP);
  ~param();

  TQString name;  // Name of flag
  bool init;         // Initial value
  bool invert;       // Whether it needs to be inverted
  TQString flag; // text flag on command
  TQString flagA; // text flag on command
};

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
class pkgInterface: public TQObject
{
  TQ_OBJECT
  

public:
  pkgInterface();
  virtual ~pkgInterface();

  virtual bool isType(char *buf, const TQString &fname) =  0;
  // looks at start of file to check that package is correct type

  virtual void makeMenu(TDEActionCollection* act);
  virtual void setMenu(TDEActionCollection* act, bool enable);

  bool ifExe(TQString exe);
  // Check if this executable exists
  
  virtual packageInfo *getPackageInfo(char mode, const TQString &name,
				      const TQString &version) =  0;
  // get info on installed or uninstalled package. version is only set if
  // mode is 'i' (ie, if the package is already installed).

  virtual TQStringList getFileList(packageInfo *p) =  0;
  // get list of files in the package

  virtual TQStringList depends(const TQString &name, int src);
  // check dependencies for package

  virtual TQStringList verify(packageInfo *p, const TQStringList &files);
  // check the installed files in a package

  virtual TQStringList FindFile(const TQString &name, bool seachAll=false) = 0;
  // search for packages containg a file

  virtual TQStringList getChangeLog(packageInfo *p) = 0;
  // Get change log

  virtual bool filesTab(packageInfo *p) = 0;
  // If files tab is to be enabled

  virtual bool changeTab(packageInfo *p) = 0;
  // If change log tab is to be enabled

  virtual bool parseName(const TQString &name, TQString *n, TQString *v) = 0;
  // breakup file name into package name and version

  virtual void listPackages(TQPtrList<packageInfo> *pki);
  // scan various locations for list of packages

  virtual void listInstalledPackages(TQPtrList<packageInfo> *pki) = 0;
  // produce list of currently installed packages

  virtual TQStringList  listInstalls(const TQStringList &packs, bool install, bool &cancel);
  // Convert list of packages requested to install to list of all packages to install

  virtual void smerge(packageInfo *p);
  // merge in package info entry

  TQString getDir(cacheObj *cp);
  // list directory local or remote

  void listDir(TQPtrList<packageInfo> *pki, const TQString &fname, const TQString &dir, bool subdirs = FALSE);
  // list the packages in a directory

  packageInfo *collectDir(const TQString &name, const TQString &size, const TQString &dir);
  // build packageInfo object from directory entry

  TQString getPackList(cacheObj *cp);
  // get packages information file

  virtual TQString  provMap(const TQString &p);
  // convert from package depends to package

  TQString setOptions(int flags, TQPtrList<param> &params);
  // convert un/install flags to text

  virtual TQString doUninstall(int uninstallFlags, const TQString &packs, bool &test);
  virtual TQString doInstall(int installFlags, const TQString &packs, bool &test);
  virtual TQString uninstall(int uninstallFlags, TQPtrList<packageInfo> *p,
				  bool &test);
  virtual TQString uninstall(int uninstallFlags, packageInfo *p,
				  bool &test);
  virtual TQString install(int installFlags, TQPtrList<packageInfo> *p,
				  bool &test);
  virtual TQString install(int installFlags, packageInfo *p,
				  bool &test);

  virtual TQStringList readApt();
  virtual void writeApt(const TQStringList &list);

  ///////////// DATA ///////////////////////
  pkgOptions *uninstallation, *installation;

  TQString icon;
  // name icon file
  TQString head;
  // capitalized name of package type
  TQString name;
  // More descriptive name
  TQPixmap pict, bad_pict, new_pict, updated_pict;
  // icons for package states
  TQPixmap folder;
  // icon for package group
  TQPixmap markInst;
  TQPixmap markUnInst;
  // icon indicating mark for install/uninstall

  Locations *locatedialog;
  // dialog for setting the locations of  uninstalled packages
  LcacheObj *packageLoc;
  // List of locations of uninstalled pacckages

  bool dirOK;
  // variables related to reading packages from directories

  TQString packagePattern;
  TQString queryMsg;
  TQString typeID;
  // Parameters for reading packages from directories

  TQPtrList<param> paramsInst;
  TQPtrList<param> paramsUninst;

  bool noFetch;
  // kpackage doesn't fetch this type of package itself

  bool defaultHandle;
  // This package type defaults to on

  TQString errExe;
  // The name of an executable that wasn't found

  TQString procMsg;
  // for running processes

  TQString DELMSG;

  bool hasRemote;
  // can access on remote host

  bool hasSearchAll;
  // can search uninstalled packages for files

  bool hasProgram;
  // the program needed to handle this package type is available

public slots:
  virtual void setLocation() = 0;
  virtual void setAvail(LcacheObj *) = 0;
};

#endif
