/***************************************************************************
* $Id$
**
* Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
* This file is part of an example program for Qt.  This example
* program may be used, distributed and modified without limitation.
**
****************************************************************************/
import org.trinitydesktop.qt.*;

class ButtonsGroups extends TQWidget
{
protected TQCheckBox state;
protected TQRadioButton rb21, rb22, rb23;




/*
  Constructor
 *
  Creates all child widgets of the ButtonGroups window
 */

public ButtonsGroups( )
{
	this(null, null);
}

public ButtonsGroups( TQWidget parent, String name )
{
    super( parent, name );
    // Create Widgets which allow easy layouting
    TQVBoxLayout vbox = new TQVBoxLayout( this );
    TQHBoxLayout box1 = new TQHBoxLayout( vbox );
    TQHBoxLayout box2 = new TQHBoxLayout( vbox );

    // ------- first group

    // Create an exclusive button group
    TQButtonGroup bgrp1 = new TQButtonGroup( 1, TQGroupBox.Horizontal, "Button Group 1 (exclusive)", this);
    box1.addWidget( bgrp1 );
    bgrp1.setExclusive( true );

    // insert 3 radiobuttons
    TQRadioButton rb11 = new TQRadioButton( "&Radiobutton 1", bgrp1 );
    rb11.setChecked( true );
    new TQRadioButton( "R&adiobutton 2", bgrp1 );
    new TQRadioButton( "Ra&diobutton 3", bgrp1 );

    // ------- second group

    // Create a non-exclusive buttongroup
    TQButtonGroup bgrp2 = new TQButtonGroup( 1, TQGroupBox.Horizontal, "Button Group 2 (non-exclusive)", this );
    box1.addWidget( bgrp2 );
    bgrp2.setExclusive( false );

    // insert 3 checkboxes
    new TQCheckBox( "&Checkbox 1", bgrp2 );
    TQCheckBox cb12 = new TQCheckBox( "C&heckbox 2", bgrp2 );
    cb12.setChecked( true );
    TQCheckBox cb13 = new TQCheckBox( "Triple &State Button", bgrp2 );
    cb13.setTristate( true );
    cb13.setChecked( true );

    // ------------ third group

    // create a buttongroup which is exclusive for radiobuttons and non-exclusive for all other buttons
    TQButtonGroup bgrp3 = new TQButtonGroup( 1, TQGroupBox.Horizontal, "Button Group 3 (Radiobutton-exclusive)", this );
    box2.addWidget( bgrp3 );
    bgrp3.setRadioButtonExclusive( true );

    // insert three radiobuttons
    rb21 = new TQRadioButton( "Rad&iobutton 1", bgrp3 );
    rb22 = new TQRadioButton( "Radi&obutton 2", bgrp3 );
    rb23 = new TQRadioButton( "Radio&button 3", bgrp3 );
    rb23.setChecked( true );

    // insert a checkbox...
    state = new TQCheckBox( "E&nable Radiobuttons", bgrp3 );
    state.setChecked( true );
    // ...and connect its signal clicked() with the slot slotChangeGrp3State()
    connect( state, TQ_SIGNAL(" clicked()"), this, TQ_SLOT(" slotChangeGrp3State()") );

    // ------------ fourth group

    // create a groupbox which layouts its childs in a columns
    TQGroupBox bgrp4 = new TQButtonGroup( 1, TQGroupBox.Horizontal, "Groupbox with normal buttons", this );
    box2.addWidget( bgrp4 );

    // insert three pushbuttons...
    new TQPushButton( "&Push Button", bgrp4 );
    TQPushButton tb2 = new TQPushButton( "&Toggle Button", bgrp4 );
    TQPushButton tb3 = new TQPushButton( "&Flat Button", bgrp4 );

    // ... and make the second one a toggle button
    tb2.setToggleButton( true );
    tb2.setOn( true );

    // ... and make the third one a flat button
    tb3.setFlat(true);
}

/*
  TQ_SLOT slotChangeGrp3State()
 *
  enables/disables the radiobuttons of the third buttongroup
 */

public void slotChangeGrp3State()
{
    rb21.setEnabled( state.isChecked() );
    rb22.setEnabled( state.isChecked() );
    rb23.setEnabled( state.isChecked() );
}
}
