/*
 *
 *  New Bluetooth App for TDE and bluez5
 *
 *  Copyright (C) 2018  Emanoil Kotsev <deloptes@gmail.com>
 *
 *
 *  This file is part of tdebluez.
 *
 *  tdebluez is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  tdebluez is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with kbluetooth; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef APPLICATION_H_
#define APPLICATION_H_

#include <tdeuniqueapplication.h>
#include <tdemessagebox.h>
#include <tqprocess.h>

#include <objectmanagerImpl.h>

class TDEConfig;
class TrayIcon;
class AdapterConfig;
class AdapterConfigDialog;
class DeviceWizard;

using namespace TDEBluetooth;

class TDEBluetoothApp: public TDEUniqueApplication
{
    TQ_OBJECT

public:
    TDEBluetoothApp();
    ~TDEBluetoothApp();

    typedef TQMap<TQString,AdapterImpl*> AdaptersMap;
    typedef TQMap<TQString,DeviceImpl*> DevicesMap;

    bool startAuthAgent();
    bool stopAuthAgent();

    bool startObexSrv();
    bool stopObexSrv();

    bool isConnected();

protected:
    ObjectManagerImpl *manager;
    AdaptersMap adapters;
    DevicesMap devices;
    void setAutoStart(bool val);
    void setStartObex(bool val);
    void setStartAuthAgent(bool val);
    bool getAutoStart();
    bool getStartObex();
    bool getStartAuthAgent();

private:
    TQProcess *obexServer;
    TQProcess *authAgent;
    TrayIcon  *trayIcon;
    TDEConfig *m_config;
    int m_waitBeforeKill;

    friend class TrayIcon;
    friend class AdapterConfig;
    friend class AdapterConfigDialog;
    friend class DeviceWizard;

public slots:
    void slotAdapterAdded(const TQString& adapter);
    void slotAdapterRemoved(const TQString& adapter);
    //	void slotPowerOnChanged(const TQString&, bool);
    void slotDeviceAdded(const TQString& device);
    void slotDeviceRemoved(const TQString& device);

signals:
    void signalAdapterAdded(const TQString &adapter);
    void signalAdapterRemoved(const TQString &adapter);
};

#endif // APPLICATION_H_
