#ifndef NEWGAME_H
#define NEWGAME_H

#include <kdialogbase.h>
#include <klineedit.h>
#include <kcolorbutton.h>

#include <tqcheckbox.h>
#include <tqcolor.h>
#include <tqptrlist.h>
#include <tqstring.h>
#include <kpushbutton.h>
#include <tqstringlist.h>
#include <tqvaluelist.h>
#include <tqwidget.h>

#include "game.h"

class KLineEdit;
class TQFrame;
class TQVBoxLayout;
class TQVBox;
class TQPainter;
class TDEListBox;
class TQEvent;

class PlayerEditor : public TQWidget
{
	TQ_OBJECT
  
	
public:
	PlayerEditor(TQString name = TQString(), TQColor = red, TQWidget *parent = 0, const char *_name = 0);
	TQColor color() { return colorButton->color(); }
	TQString name() { return editor->text(); }
	void setColor(TQColor col) { colorButton->setColor(col); }
	void setName(const TQString &newname) { editor->setText(newname); }

signals:
	void deleteEditor(PlayerEditor *editor);

private slots:
	void removeMe();

private:
	KLineEdit *editor;
	KColorButton *colorButton;
	TQPixmap grass;
};

class NewGameDialog : public KDialogBase
{
	TQ_OBJECT
  

public:
	NewGameDialog(bool enableCourses, TQWidget *parent, const char *_name = 0);
	TQPtrList<PlayerEditor> *players() { return &editors; }
	bool competition() { return mode->isChecked(); }
	TQString course() { return currentCourse; }

public slots:
	void deleteEditor(PlayerEditor *);

protected slots:
	void slotOk();

private slots:
	void addPlayer();
	void courseSelected(int);
	void addCourse();
	void removeCourse();
	void selectionChanged();
	void showHighscores();

private:
	TQVBox *layout;
	KPushButton *addButton;
	TQFrame *playerPage;
	TQScrollView *scroller;
	TQFrame *coursePage;
	TQFrame *optionsPage;
	TQValueList<TQColor> startColors;
	TQPtrList<PlayerEditor> editors;
	KPushButton *remove;
	TQCheckBox *mode;

	TQPixmap grass;

	TQStringList names;
	TQStringList externCourses;
	TQMap<TQString, CourseInfo> info;

	TQStringList extraCourses;

	TDEListBox *courseList;
	TQLabel *name;
	TQLabel *author;
	TQLabel *par;
	TQLabel *holes;

	TQString currentCourse;

	void enableButtons();
	bool enableCourses;
};

#endif
