/*
 *              KSCD -- a simpole cd player for the KDE project
 *
 * $Id$
 *
 *              Copyright (C) 1997 Bernd Johannes Wuebben
 *                      wuebben@math.cornell.edu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "docking.h"
#include "kscd.h"

#include <tqhbox.h>
#include <tqtooltip.h>

#include <tdeaboutdata.h>
#include <tdeactioncollection.h>
#include <tdeapplication.h>
#include <tdelocale.h>
#include <tdeglobal.h>
#include <kiconloader.h>
#include <tdepopupmenu.h>
#include <kpassivepopup.h>

#include <kdebug.h>

DockWidget::DockWidget( KSCD* parent, const char *name)
    : KSystemTray( parent, name )
{
    m_popup = 0;
    setPixmap( loadIcon("cdsmall") );

    TDEActionCollection* actionCollection = parent->actionCollection();
    m_backAction = actionCollection->action("Previous");
    m_forwardAction = actionCollection->action("Next");
    m_backPix = loadIcon("media-skip-backward");
    m_forwardPix = loadIcon("media-skip-forward");

    // popup menu for right mouse button
    TQPopupMenu* popup = contextMenu();

    popup->insertItem(TDEGlobal::iconLoader()->loadIconSet("media-playback-start", TDEIcon::Small), i18n("Play/Pause"), parent, TQ_SLOT(playClicked()));
    popup->insertItem(TDEGlobal::iconLoader()->loadIconSet("media-playback-stop", TDEIcon::Small), i18n("Stop"), parent, TQ_SLOT(stopClicked()));
    popup->insertItem(TDEGlobal::iconLoader()->loadIconSet("media-skip-forward", TDEIcon::Small), i18n("Next"), parent, TQ_SLOT(nextClicked()));
    popup->insertItem(TDEGlobal::iconLoader()->loadIconSet("media-skip-backward", TDEIcon::Small), i18n("Previous"), parent, TQ_SLOT(prevClicked()));
    popup->insertItem(TDEGlobal::iconLoader()->loadIconSet("player_eject", TDEIcon::Small), i18n("Eject"), parent, TQ_SLOT(ejectClicked()));

    TQToolTip::add(this, tdeApp->aboutData()->programName());
}

DockWidget::~DockWidget()
{
}

void DockWidget::createPopup(const TQString &songName, bool addButtons)
{
    if (!Prefs::trackAnnouncement())
        return;

    delete m_popup;
    m_popup = new KPassivePopup(this);

    TQHBox* box = new TQHBox(m_popup);
    
    if (addButtons)
    {
        TQPushButton* backButton = new TQPushButton(m_backPix, 0, box, "popup_back");
        backButton->setFlat(true);
        connect(backButton, TQ_SIGNAL(clicked()), m_backAction, TQ_SLOT(activate()));
    }

    TQLabel* l = new TQLabel(songName, box);
    l->setMargin(3);

    if (addButtons)
    {
        TQPushButton* forwardButton = new TQPushButton(m_forwardPix, 0, box, "popup_forward");
        forwardButton->setFlat(true);
        connect(forwardButton, TQ_SIGNAL(clicked()), m_forwardAction, TQ_SLOT(activate()));
    }

    m_popup->setView(box);
    m_popup->setAutoDelete(false);
    m_popup->show();
}

void DockWidget::setToolTip(const TQString& text)
{
    if (tip == text)
    {
        return;
    }

    tip = text;
    TQToolTip::remove(this);

    if (text.isEmpty())
    {
        TQToolTip::add(this, tdeApp->aboutData()->programName());
    }
    else
    {
        TQToolTip::add(this, text);
    }
}

void DockWidget::wheelEvent(TQWheelEvent *e)
{
    if (e->orientation() ==TQt::Horizontal)
        return;

    KSCD* kscd = dynamic_cast<KSCD*>(parent());
    if (kscd == 0)
        return;

    switch (e->state())
    {
        case ShiftButton:
        {
            if (e->delta() > 0)
            {
                kscd->incVolume();
            }
            else
            {
                kscd->decVolume();
            }
            break;
        }
        default:
        {
            if (e->delta() > 0)
            {
                kscd->nextClicked();
            }
            else
            {
                kscd->prevClicked();
            }
        }
    }
}

#include "docking.moc"
