#include "find.h"
#include <tqlayout.h>
#include <kcombobox.h>
#include <tqpushbutton.h>
#include <tqcheckbox.h>
#include <tdelocale.h>

Finder::Finder(TQWidget *parent) : KDialogBase(parent, 0, false, i18n("Find"), Close | User1, User1, false, KGuiItem(i18n("&Find"),"edit-find"))
{
	TQWidget *mainWidget = new TQWidget(this);
	mainWidget->setMinimumWidth(320);
	setMainWidget(mainWidget);

	TQGridLayout *layout=new TQGridLayout(mainWidget);
	layout->setSpacing(KDialog::spacingHint());

	mText=new KHistoryCombo(mainWidget);
	mText->setMaxCount(10);

	mText->setFocus();

	mRegexp=new TQCheckBox(i18n("&Regular expression"), mainWidget);
	mBackwards=new TQCheckBox(i18n("Find &backwards"), mainWidget);

	layout->addMultiCellWidget(mText, 0, 0, 0, 1);
	layout->addWidget(mRegexp, 1, 0);
	layout->addWidget(mBackwards, 1, 1);

	connect(this, TQ_SIGNAL(user1Clicked()), TQ_SLOT(clicked()));

	connect(mText, TQ_SIGNAL(activated(int)), TQ_SLOT(clicked()));
	connect(mText, TQ_SIGNAL(textChanged(const TQString &)), TQ_SLOT(textChanged(const TQString &)));

	enableButton(User1, false);
}

void Finder::textChanged(const TQString &text) {
	enableButton(User1, !text.isEmpty());
}

bool Finder::regexp() const
{
	return mRegexp->isChecked();
}

bool Finder::isForward() const
{
	return !mBackwards->isChecked();
}

void Finder::clicked()
{
	mText->addToHistory( mText->currentText() );
	emit search(this);
}

TQString Finder::string() const
{
	return mText->currentText();
}


#include "find.moc"
