/*
 * KMix -- KDE's full featured mini mixer
 *
 *
 * Copyright (C) 2000 Stefan Schimanski <1Stein@gmx.de>
 *               1996-2000 Christian Esken <esken@kde.org>
 *                         Sven Fischer <herpes@kawo2.rwth-aachen.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef MIXDEVICEWIDGET_H
#define MIXDEVICEWIDGET_H

#include <kpanelapplet.h>

#include <tqwidget.h>
#include "volume.h"
#include <tqptrlist.h>
#include <tqpixmap.h>
#include <tqrangecontrol.h>

class TQBoxLayout;
class TQLabel;
class TQPopupMenu;
class TQSlider;

class KLed;
class KLedButton;
class TDEAction;
class TDEActionCollection;
class KSmallSlider;
class TDEGlobalAccel;

class MixDevice;
class VerticalText;
class Mixer;
class ViewBase;

class MixDeviceWidget
 : public TQWidget
{
      TQ_OBJECT
  

public:
    enum ValueStyle { NNONE = 0, NABSOLUTE = 1, NRELATIVE = 2 } ;

      MixDeviceWidget( Mixer *mixer, MixDevice* md,
                       bool small, TQt::Orientation orientation,
                       TQWidget* parent = 0, ViewBase* mw = 0, const char* name = 0);
    ~MixDeviceWidget();

    void addActionToPopup( TDEAction *action );

    virtual bool isDisabled() const;
    MixDevice* mixDevice() { return m_mixdevice; };

    virtual void setColors( TQColor high, TQColor low, TQColor back );
    virtual void setIcons( bool value );
    virtual void setMutedColors( TQColor high, TQColor low, TQColor back );

    virtual bool isStereoLinked() const { return false; };
    //virtual bool isLabeled() const { return false; };
    virtual void setStereoLinked( bool ) {};
    virtual void setLabeled( bool );
    virtual void setTicks( bool ) {};
    virtual void setValueStyle( ValueStyle ) {};

    virtual TDEGlobalAccel *keys(void);

public slots:
    virtual void setDisabled( bool value );
    virtual void defineKeys();
    virtual void update();
    virtual void showContextMenu();

signals:
    void newVolume( int num, Volume volume );
    void newMasterVolume( Volume volume );
    void masterMuted( bool );
    void newRecsrc( int num, bool on );

protected slots:
    void volumeChange( int );
    virtual void setVolume( int channel, int volume );
    virtual void setVolume( Volume volume );

protected:
      Mixer*               m_mixer;
      MixDevice*           m_mixdevice;
      TDEActionCollection*   _mdwActions;
      TDEGlobalAccel*        m_keys;
      ViewBase*            m_mixerwidget;
      bool                 m_disabled;
      TQt::Orientation      _orientation;
      bool                 m_small;

private:
      void mousePressEvent( TQMouseEvent *e );
};

#endif
