/*
    This file is part of Kung.

    Copyright (c) 2005 Tobias Koenig <tokoe@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include <tdeaboutdata.h>
#include <tdeapplication.h>
#include <tdecmdlineargs.h>
#include <kdebug.h>
#include <tdelocale.h>

#include <tqtimer.h>

#include "loader.h"

static const TDECmdLineOptions options[] =
{
  { "+wsdl", I18N_NOOP( "Location of WSDL file" ), 0 },
  TDECmdLineLastOption
};

int main( int argc, char **argv )
{
  TDEAboutData aboutData( "kung", I18N_NOOP( "TDE WSDL Interpreter" ), "0.1",
                        I18N_NOOP( "TDE WSDL Interpreter" ),
                        TDEAboutData::License_LGPL );

  aboutData.addAuthor( "Tobias Koenig", 0, "tokoe@kde.org" );

  TDECmdLineArgs::init( argc, argv, &aboutData );
  TDECmdLineArgs::addCmdLineOptions( options );

  TDECmdLineArgs *args = TDECmdLineArgs::parsedArgs();

  if ( args->count() == 0 ) {
    kdError() << "No WSDL file given." << endl;
    return 1;
  }

  TDEApplication app;

  Loader loader;
  loader.setWSDLUrl( args->url( 0 ).path() );

  TQTimer::singleShot( 0, &loader, TQ_SLOT( run() ) );

  return app.exec();
}
