/*
    This file is part of tdepim.

    Copyright (c) 2004 Cornelius Schumacher <schumacher@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "style.h"

#include <kdebug.h>

#include <tqfile.h>
#include <tqtextstream.h>

using namespace KODE;

Style::Style()
{
}

Style::~Style()
{
}

TQString Style::className( const TQString &str )
{
  return upperFirst( str );
}

TQString Style::upperFirst( const TQString &str )
{
  if ( str.isEmpty() ) return str;
  return str[ 0 ].upper() + str.mid( 1 );
}

TQString Style::lowerFirst( const TQString &str )
{
  if ( str.isEmpty() ) return str;
  return str[ 0 ].lower() + str.mid( 1 );
}
