/*
    This file is part of KOrganizer.

    Copyright (c) 2001,2003 Cornelius Schumacher <schumacher@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/
#ifndef KOEVENTVIEWER_H
#define KOEVENTVIEWER_H

#include <tdemacros.h>
#include <tdeconfig.h>
#include <tqtextbrowser.h>

namespace KCal {
  class Calendar;
  class Incidence;
}
using namespace KCal;

/**
  Viewer widget for events.
*/
class TDE_EXPORT KOEventViewer : public TQTextBrowser
{
  TQ_OBJECT
  
  public:
    explicit KOEventViewer( Calendar *calendar, TQWidget *parent = 0, const char *name = 0 );
    virtual ~KOEventViewer();

    /**
      Reimplemented from TQTextBrowser to handle links.
    */
    void setSource( const TQString & );

    virtual bool appendIncidence( Incidence *incidence, const TQDate &date );

    /**
      Set the Calendar associated with this viewer.
    */
    void setCalendar ( Calendar *calendar );

    /**
      Clear viewer. If \a now is set to true delete view immediately. If set to
      false delete it with next call to appendIncidence().
    */
    void clearEvents( bool now = false );

    /**
      Add given text to currently shown content.
    */

    void addText( const TQString &text );

    /**
      Set the default text that is showed when
      there aren't a incidence to show
    */
    void setDefaultText( const TQString &text );

    void readSettings( TDEConfig *config );
    void writeSettings ( TDEConfig *config );

  public slots:
    /**
      Show given incidence in viewer. Clear all previously shown incidences.
    */
    void setIncidence( Incidence *incidence, const TQDate &date );
    void changeIncidenceDisplay( Incidence *incidence, const TQDate &date, int action );
    void message( const TQString &link );
    void contentsContextMenuEvent( TQContextMenuEvent * );

  private:
    Calendar *mCalendar;
    Incidence *mIncidence;
    TQTextBrowser *mEventTextView;
    TQString mDefaultText;
    TQString mText;
    TQString mAttachLink;
};

#endif
