/*
 * Copyright (C) 2004, Mart Kelder (mart.kde@hccnet.nl)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef MK_TDEIO_READ_H
#define MK_TDEIO_READ_H

//This class should be used if someone wants to read the Full Message

#include <tqobject.h>

class KKioDrop;
class KornMailId;

class KURL;
namespace TDEIO { class MetaData; class Job; }
class TDEIO_Protocol;

class TQString;

class TDEIO_Read : public TQObject
{ TQ_OBJECT
  
public:
	TDEIO_Read( TQObject * parent = 0, const char * name = 0 );
	~TDEIO_Read();

public slots:
	//This is the function which makes the nessesairy slaves for reading a message
	void readMail( const KornMailId *&, KKioDrop* );
	//This function should be called if the user presses canceled.
	void canceled();
private:
	KKioDrop *_tdeio;
	TDEIO::Job *_job;
	TQString *_message;
	
signals:
	//This signal is emitted when the whole message is read; the message got passed as TQString*
	void ready( TQString* );
	
private slots:
	void slotResult( TDEIO::Job* );
	void slotData( TDEIO::Job*, const TQByteArray& );
};

#endif //MK_TDEIO_READ_H
