/*
    This file is part of libtdepim.

    Copyright (c) 2004 Tobias Koenig <tokoe@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "addresseediffalgo.h"

using namespace KPIM;

static bool compareString( const TQString &left, const TQString &right )
{
  if ( left.isEmpty() && right.isEmpty() )
    return true;
  else
    return left == right;
}

AddresseeDiffAlgo::AddresseeDiffAlgo( const TDEABC::Addressee &leftAddressee,
                              const TDEABC::Addressee &rightAddressee )
  : mLeftAddressee( leftAddressee ), mRightAddressee( rightAddressee )
{
}

void AddresseeDiffAlgo::run()
{
  begin();

  if ( !compareString( mLeftAddressee.uid(), mRightAddressee.uid() ) )
    conflictField( TDEABC::Addressee::uidLabel(), mLeftAddressee.uid(), mRightAddressee.uid() );

  if ( !compareString( mLeftAddressee.name(), mRightAddressee.name() ) )
    conflictField( TDEABC::Addressee::nameLabel(), mLeftAddressee.name(), mRightAddressee.name() );

  if ( !compareString( mLeftAddressee.formattedName(), mRightAddressee.formattedName() ) )
    conflictField( TDEABC::Addressee::formattedNameLabel(), mLeftAddressee.formattedName(), mRightAddressee.formattedName() );

  if ( !compareString( mLeftAddressee.familyName(), mRightAddressee.familyName() ) )
    conflictField( TDEABC::Addressee::familyNameLabel(), mLeftAddressee.familyName(), mRightAddressee.familyName() );

  if ( !compareString( mLeftAddressee.givenName(), mRightAddressee.givenName() ) )
    conflictField( TDEABC::Addressee::givenNameLabel(), mLeftAddressee.givenName(), mRightAddressee.givenName() );

  if ( !compareString( mLeftAddressee.additionalName(), mRightAddressee.additionalName() ) )
    conflictField( TDEABC::Addressee::additionalNameLabel(), mLeftAddressee.additionalName(), mRightAddressee.additionalName() );

  if ( !compareString( mLeftAddressee.prefix(), mRightAddressee.prefix() ) )
    conflictField( TDEABC::Addressee::prefixLabel(), mLeftAddressee.prefix(), mRightAddressee.prefix() );

  if ( !compareString( mLeftAddressee.suffix(), mRightAddressee.suffix() ) )
    conflictField( TDEABC::Addressee::suffixLabel(), mLeftAddressee.suffix(), mRightAddressee.suffix() );

  if ( !compareString( mLeftAddressee.nickName(), mRightAddressee.nickName() ) )
    conflictField( TDEABC::Addressee::nickNameLabel(), mLeftAddressee.nickName(), mRightAddressee.nickName() );

  if ( mLeftAddressee.birthday() != mRightAddressee.birthday() )
    conflictField( TDEABC::Addressee::birthdayLabel(), mLeftAddressee.birthday().toString(),
                   mRightAddressee.birthday().toString() );

  if ( !compareString( mLeftAddressee.mailer(), mRightAddressee.mailer() ) )
    conflictField( TDEABC::Addressee::mailerLabel(), mLeftAddressee.mailer(), mRightAddressee.mailer() );

  if ( mLeftAddressee.timeZone() != mRightAddressee.timeZone() )
    conflictField( TDEABC::Addressee::timeZoneLabel(), mLeftAddressee.timeZone().asString(), mRightAddressee.timeZone().asString() );

  if ( mLeftAddressee.geo() != mRightAddressee.geo() )
    conflictField( TDEABC::Addressee::geoLabel(), mLeftAddressee.geo().asString(), mRightAddressee.geo().asString() );

  if ( !compareString( mLeftAddressee.title(), mRightAddressee.title() ) )
    conflictField( TDEABC::Addressee::titleLabel(), mLeftAddressee.title(), mRightAddressee.title() );

  if ( !compareString( mLeftAddressee.role(), mRightAddressee.role() ) )
    conflictField( TDEABC::Addressee::roleLabel(), mLeftAddressee.role(), mRightAddressee.role() );

  if ( !compareString( mLeftAddressee.organization(), mRightAddressee.organization() ) )
    conflictField( TDEABC::Addressee::organizationLabel(), mLeftAddressee.organization(), mRightAddressee.organization() );

  if ( !compareString( mLeftAddressee.note(), mRightAddressee.note() ) )
    conflictField( TDEABC::Addressee::noteLabel(), mLeftAddressee.note(), mRightAddressee.note() );

  if ( !compareString( mLeftAddressee.productId(), mRightAddressee.productId() ) )
    conflictField( TDEABC::Addressee::productIdLabel(), mLeftAddressee.productId(), mRightAddressee.productId() );

  if ( !compareString( mLeftAddressee.sortString(), mRightAddressee.sortString() ) )
    conflictField( TDEABC::Addressee::sortStringLabel(), mLeftAddressee.sortString(), mRightAddressee.sortString() );

  if ( mLeftAddressee.secrecy() != mRightAddressee.secrecy() ) {
    conflictField( TDEABC::Addressee::secrecyLabel(), mLeftAddressee.secrecy().asString(), mRightAddressee.secrecy().asString() );
  }
  if ( mLeftAddressee.url()!= mRightAddressee.url() )
    conflictField( TDEABC::Addressee::urlLabel(), mLeftAddressee.url().prettyURL(),
      mRightAddressee.url().prettyURL() );
    
  if ( mLeftAddressee.logo() != mRightAddressee.logo() ) {
  }

  if ( mLeftAddressee.photo() != mRightAddressee.photo() ) {
  }

  diffList( "emails", mLeftAddressee.emails(), mRightAddressee.emails() );

  diffList( "Phone Numbers", mLeftAddressee.phoneNumbers(), mRightAddressee.phoneNumbers() );
  diffList( "Addresses", mLeftAddressee.addresses(), mRightAddressee.addresses() );

  end();
}

TQString AddresseeDiffAlgo::toString( const TDEABC::PhoneNumber &number )
{
  return number.number();
}

TQString AddresseeDiffAlgo::toString( const TDEABC::Address &addr )
{
  return addr.formattedAddress();
}

template <class L>
void AddresseeDiffAlgo::diffList( const TQString &id,
                                  const TQValueList<L> &left, const TQValueList<L> &right )
{
  for ( uint i = 0; i < left.count(); ++i ) {
    if ( right.find( left[ i ] ) == right.end() )
      additionalLeftField( id, toString( left[ i ] ) );
  }

  for ( uint i = 0; i < right.count(); ++i ) {
    if ( left.find( right[ i ] ) == left.end() )
      additionalRightField( id, toString( right[ i ] ) );
  }
}
